/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.Auditable;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkConstraints;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.ToolDefSource;

public class MapSetup
implements MapDefSource {
    private Mapping myMap;
    private NodeMapping myNodeA;
    private NodeMapping myNodeB;
    private LinkMapping myClassLink;
    private LinkMapping myRefLink;

    public MapSetup init(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
        this.initCanvasMappping(domainSource.getModel(), ddSource.getCanvasDef(), domainSource.getDiagramElement());
        if (toolDef.getMainMenu() != null) {
            this.myMap.getDiagram().getMenuContributions().add((Object)toolDef.getMainMenu());
        }
        this.myMap.getDiagram().setPalette(toolDef.getPalette());
        this.myNodeA = this.createNodeMapping(ddSource.getNodeDef(), ddSource.getLabelDef(), domainSource.getNodeA());
        this.myNodeA.setContextMenu(toolDef.getNodeContextMenu());
        this.myNodeA.setTool(toolDef.getNodeCreationTool());
        if (domainSource.getNodeB() != null) {
            this.myNodeB = this.createNodeMapping(ddSource.getNodeDef(), ddSource.getLabelDef(), domainSource.getNodeB());
        }
        this.myClassLink = this.createLinkMapping(ddSource.getLinkDef(), domainSource.getLinkAsClass());
        this.myClassLink.setTool(toolDef.getLinkCreationTool());
        if (domainSource.getLinkAsRef() != null) {
            this.myRefLink = this.createLinkMapping(ddSource.getLinkDef(), null, (EStructuralFeature)domainSource.getLinkAsRef(), null);
        }
        return this;
    }

    private void initCanvasMappping(EPackage domainModel, Canvas canvas, EClass diagramElement) {
        Mapping m = GMFMapFactory.eINSTANCE.createMapping();
        CanvasMapping cme = GMFMapFactory.eINSTANCE.createCanvasMapping();
        cme.setDiagramCanvas(canvas);
        cme.setDomainMetaElement(diagramElement);
        cme.setDomainModel(domainModel);
        this.setupCanvasMapping(cme);
        m.setDiagram(cme);
        this.myMap = m;
    }

    protected final AuditRule createAudit(String id, String ruleBody, Auditable target, Severity severity, boolean isLiveMode) {
        AuditRule audit = GMFMapFactory.eINSTANCE.createAuditRule();
        audit.setId(id);
        audit.setName("Name of \"" + id + "\"");
        audit.setMessage("Violation of \"" + id + "\"");
        audit.setDescription("Description of \"" + id + "\"");
        audit.setTarget(target);
        Constraint rule = GMFMapFactory.eINSTANCE.createConstraint();
        rule.setBody(ruleBody);
        audit.setRule(rule);
        audit.setSeverity(severity);
        audit.setUseInLiveMode(isLiveMode);
        return audit;
    }

    protected final AuditContainer createAuditContainer(String id) {
        AuditContainer container = GMFMapFactory.eINSTANCE.createAuditContainer();
        container.setId(id);
        container.setName("Name of \"" + id + "\"");
        container.setDescription("Description of \"" + id + "\"");
        return container;
    }

    private LinkMapping createLinkMapping(Connection link, DomainModelSource.LinkData data) {
        return this.createLinkMapping(link, data.getEClass(), data.getTargetFeature(), data.getContainment());
    }

    private LinkMapping createLinkMapping(Connection link, EClass domainMetaElement, EStructuralFeature linkMetafeature, EReference containmentFeature) {
        LinkMapping lme = GMFMapFactory.eINSTANCE.createLinkMapping();
        lme.setDiagramLink(link);
        lme.setDomainMetaElement(domainMetaElement);
        lme.setLinkMetaFeature(linkMetafeature);
        lme.setContainmentFeature(containmentFeature);
        if (domainMetaElement == null) {
            this.setupReferenceLinkMapping(lme);
        } else {
            this.setupClassLinkMapping(lme);
        }
        this.myMap.getLinks().add((Object)lme);
        return lme;
    }

    private NodeMapping createNodeMapping(Node nodeDef, DiagramLabel labelDef, DomainModelSource.NodeData nodeData) {
        return this.createNodeMapping(nodeDef, nodeData.getEClass(), labelDef, nodeData.getNameAttr(), nodeData.getContainment());
    }

    private NodeMapping createNodeMapping(Node nodeDef, EClass domainMetaElement, DiagramLabel labelDef, EAttribute editFeature, EReference containmentFeature) {
        return this.createNodeMapping(nodeDef, domainMetaElement, labelDef, editFeature, containmentFeature, true);
    }

    protected final NodeMapping createNodeMapping(Node nodeDef, EClass domainMetaElement, DiagramLabel labelDef, EAttribute editFeature, EReference containmentFeature, boolean addTopNodeReference) {
        NodeMapping nme = GMFMapFactory.eINSTANCE.createNodeMapping();
        nme.setDiagramNode(nodeDef);
        nme.setDomainMetaElement(domainMetaElement);
        if (editFeature != null) {
            LabelMapping lm = GMFMapFactory.eINSTANCE.createLabelMapping();
            lm.getFeatures().add((Object)editFeature);
            lm.setDiagramLabel(labelDef);
            nme.getLabelMappings().add((Object)lm);
        }
        this.setupNodeMapping(nme);
        if (addTopNodeReference) {
            TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
            tnr.setOwnedChild(nme);
            tnr.setContainmentFeature(containmentFeature);
            this.myMap.getNodes().add((Object)tnr);
        }
        return nme;
    }

    protected void addCreationConstraints(LinkMapping linkMapping, String sourceConstraint, String endConstraint) {
        LinkConstraints constraints = GMFMapFactory.eINSTANCE.createLinkConstraints();
        Constraint source = GMFMapFactory.eINSTANCE.createConstraint();
        source.setBody(sourceConstraint);
        constraints.setSourceEnd(source);
        Constraint target = GMFMapFactory.eINSTANCE.createConstraint();
        target.setBody(endConstraint);
        constraints.setTargetEnd(target);
        linkMapping.setCreationConstraints(constraints);
    }

    protected void setupCanvasMapping(CanvasMapping cme) {
    }

    protected void setupNodeMapping(NodeMapping nme) {
    }

    protected void setupClassLinkMapping(LinkMapping lme) {
    }

    protected void setupReferenceLinkMapping(LinkMapping lme) {
    }

    public final Mapping getMapping() {
        return this.myMap;
    }

    public NodeMapping getNodeA() {
        return this.myNodeA;
    }

    public NodeMapping getNodeB() {
        return this.myNodeB;
    }

    public LinkMapping getClassLink() {
        return this.myClassLink;
    }

    public LinkMapping getReferenceLink() {
        return this.myRefLink;
    }
}

