/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Ratio;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;

public abstract class ResizableCompartmentEditPart
extends CompartmentEditPart
implements IResizableCompartmentEditPart {
    public ResizableCompartmentEditPart(EObject model) {
        super(model);
    }

    public Object getAdapter(Class key) {
        if (key == ExposeHelper.class) {
            ViewportExposeHelper helper = new ViewportExposeHelper((GraphicalEditPart)this);
            return helper;
        }
        return super.getAdapter(key);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshShowCompartmentTitle();
        this.refreshCollapsed();
        this.refreshRatio();
        this.refreshLineWidth();
        this.refreshLineType();
    }

    protected IFigure createFigure() {
        return new ResizableCompartmentFigure(this.getCompartmentName(), this.getMapMode());
    }

    public ResizableCompartmentFigure getCompartmentFigure() {
        return (ResizableCompartmentFigure)this.getFigure();
    }

    public IFigure getContentPane() {
        if (this.getCompartmentFigure() != null) {
            return this.getCompartmentFigure().getContentPane();
        }
        return null;
    }

    public String getCompartmentName() {
        return new String();
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getRatio_Value().equals(feature) || event.getOldValue() instanceof Ratio || event.getNewValue() instanceof Ratio) {
            this.refreshRatio();
        } else if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed().equals(feature)) {
            this.setCollapsed(event.getNewBooleanValue(), true);
            this.getFigure().revalidate();
        } else if (NotationPackage.eINSTANCE.getTitleStyle_ShowTitle().equals(feature)) {
            this.setShowCompartmentTitle(event.getNewBooleanValue());
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        } else if (NotationPackage.eINSTANCE.getLineTypeStyle_LineType().equals(feature)) {
            this.refreshLineType();
        } else {
            super.handleNotificationEvent(event);
        }
    }

    protected void refreshRatio() {
        if (ViewUtil.isPropertySupported((View)((View)this.getModel()), (Object)Properties.ID_RATIO)) {
            this.setRatio((Double)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getRatio_Value()));
        } else {
            this.setRatio(new Double(-1.0));
        }
    }

    protected void refreshCollapsed() {
        DrawerStyle style = (DrawerStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        if (style != null) {
            this.setCollapsed(style.isCollapsed(), false);
        }
    }

    protected void refreshShowCompartmentTitle() {
        TitleStyle style = (TitleStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getTitleStyle());
        if (style != null) {
            this.setShowCompartmentTitle(style.isShowTitle());
        }
    }

    protected void setCollapsed(boolean collapsed, boolean animate) {
        if (this.getCompartmentFigure() != null) {
            if (collapsed) {
                if (animate) {
                    this.getCompartmentFigure().collapse();
                } else {
                    this.getCompartmentFigure().setCollapsed();
                }
            } else if (animate) {
                this.getCompartmentFigure().expand();
            } else {
                this.getCompartmentFigure().setExpanded();
            }
        }
    }

    protected void setRatio(Double ratio) {
        ((IGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), ratio);
    }

    protected void setShowCompartmentTitle(boolean showCompartmentTitle) {
        if (this.getCompartmentFigure() != null) {
            this.getCompartmentFigure().setTitleVisibility(showCompartmentTitle);
        }
    }

    protected void setFont(FontData fontData) {
        if (this.getCompartmentFigure() != null) {
            fontData.setHeight(fontData.getHeight() - 1);
        }
        super.setFont(fontData);
    }

    protected void setFontColor(Color color) {
        if (this.getCompartmentFigure() != null) {
            this.getCompartmentFigure().setFontColor(color);
        }
    }

    protected void setLineWidth(int width) {
        Border border;
        if (width < 0) {
            width = 1;
        }
        if ((border = this.getFigure().getBorder()) instanceof LineBorder) {
            ((LineBorder)border).setWidth(this.getMapMode().DPtoLP(width));
            this.getFigure().revalidate();
        }
    }

    protected void setLineType(int type) {
        Border border = this.getFigure().getBorder();
        if (border instanceof LineBorder) {
            ((LineBorder)border).setStyle(type);
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("PrimaryView", this, (EObject)this.getPrimaryView());
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("PrimaryView");
    }

    public boolean isSelectable() {
        if (super.isSelectable()) {
            return !(this.getParent() instanceof ResizableCompartmentEditPart);
        }
        return false;
    }
}

