/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DiagramAction
extends AbstractActionHandler
implements Disposable {
    private Request targetRequest;
    private List _operationSet = Collections.EMPTY_LIST;

    public DiagramAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected DiagramAction(IWorkbenchPart workbenchpart) {
        super(workbenchpart);
    }

    public void dispose() {
        this.targetRequest = null;
        this._operationSet = null;
        super.dispose();
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        this.execute(this.getCommand(), progressMonitor);
    }

    public void refresh() {
        this._operationSet = null;
        this.updateTargetRequest();
        this.setEnabled(this.calculateEnabled());
    }

    protected boolean calculateEnabled() {
        Command command = this.getCommand();
        return command != null && command.canExecute();
    }

    protected final void execute(Command command, IProgressMonitor progressMonitor) {
        if (command == null || !command.canExecute()) {
            return;
        }
        if (this.getDiagramCommandStack() != null) {
            this.getDiagramCommandStack().execute(command, progressMonitor);
        }
    }

    protected DiagramCommandStack getDiagramCommandStack() {
        Object stack = this.getWorkbenchPart().getAdapter(CommandStack.class);
        return stack instanceof DiagramCommandStack ? (DiagramCommandStack)((Object)stack) : null;
    }

    protected Command getCommand() {
        return this.getCommand(this.getTargetRequest());
    }

    protected Command getCommand(Request request) {
        List operationSet = this.getOperationSet();
        Iterator editParts = operationSet.iterator();
        CompoundCommand command = new CompoundCommand(this.getCommandLabel());
        while (editParts.hasNext()) {
            EditPart editPart = (EditPart)editParts.next();
            Command curCommand = editPart.getCommand(request);
            if (curCommand == null) continue;
            command.add(curCommand);
        }
        return command.isEmpty() || command.size() != operationSet.size() ? UnexecutableCommand.INSTANCE : command;
    }

    protected String getCommandLabel() {
        return "";
    }

    protected Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected abstract Request createTargetRequest();

    protected void updateTargetRequest() {
    }

    protected void clearTargetRequest() {
        this.targetRequest = null;
    }

    protected List getSelectedObjects() {
        return this.getStructuredSelection().toList();
    }

    protected final List getOperationSet() {
        if (this._operationSet == null) {
            this._operationSet = this.createOperationSet();
            if (this._operationSet == null) {
                this._operationSet = Collections.EMPTY_LIST;
            }
        }
        return this._operationSet;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        Iterator selectedEPs = selection.iterator();
        ArrayList targetedEPs = new ArrayList();
        while (selectedEPs.hasNext()) {
            EditPart selectedEP = (EditPart)selectedEPs.next();
            targetedEPs.addAll(this.getTargetEditParts(selectedEP));
        }
        return targetedEPs.isEmpty() ? Collections.EMPTY_LIST : targetedEPs;
    }

    protected List getTargetEditParts(EditPart editpart) {
        EditPart targetEP = editpart.getTargetEditPart(this.getTargetRequest());
        return targetEP == null ? Collections.EMPTY_LIST : Collections.singletonList(targetEP);
    }

    protected IDiagramEditDomain getDiagramEditDomain() {
        return (IDiagramEditDomain)this.getWorkbenchPart().getAdapter(IDiagramEditDomain.class);
    }

    protected IDiagramWorkbenchPart getDiagramWorkbenchPart() {
        IDiagramWorkbenchPart diagramPart = null;
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part instanceof IDiagramWorkbenchPart) {
            diagramPart = (IDiagramWorkbenchPart)part;
        } else if (part != null) {
            diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
        }
        return diagramPart;
    }

    protected DiagramEditPart getDiagramEditPart() {
        IDiagramWorkbenchPart part = this.getDiagramWorkbenchPart();
        return part != null ? part.getDiagramEditPart() : null;
    }

    protected IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = this.getDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    protected List filterEditPartsMatching(List list, EditPartViewer.Conditional condition) {
        ArrayList<EditPart> matchList = new ArrayList<EditPart>();
        for (EditPart ep : list) {
            if (!condition.evaluate(ep)) continue;
            matchList.add(ep);
        }
        return matchList;
    }

    protected abstract boolean isSelectionListener();

    protected void setTargetRequest(Request targetRequest) {
        this.targetRequest = targetRequest;
    }

    protected PreferencesHint getPreferencesHint() {
        if (this.getDiagramEditPart() != null) {
            return this.getDiagramEditPart().getDiagramPreferencesHint();
        }
        return PreferencesHint.USE_DEFAULTS;
    }

    protected final Point getMouseLocation() {
        IDiagramGraphicalViewer viewer;
        Display display = Display.getCurrent();
        if (display != null && (viewer = this.getDiagramGraphicalViewer()) != null) {
            return new Point(viewer.getControl().toControl(display.getCursorLocation()));
        }
        return null;
    }
}

