/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;

public class CommandUtilities {
    public static boolean canRedo(Command command) {
        if (command == null) {
            return false;
        }
        if (command instanceof IUndoableOperation) {
            return ((IUndoableOperation)command).canRedo();
        }
        if (command instanceof CompoundCommand) {
            Iterator iter = ((CompoundCommand)command).getCommands().iterator();
            while (iter.hasNext()) {
                try {
                    if (CommandUtilities.canRedo((Command)iter.next())) continue;
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }
            return true;
        }
        if (command instanceof ICommandProxy) {
            return ((ICommandProxy)command).getICommand().canRedo();
        }
        return command.canUndo();
    }

    public static Collection getAffectedFiles(Command command) {
        if (command == null) {
            return Collections.EMPTY_LIST;
        }
        if (command instanceof ICommand) {
            return ((ICommand)command).getAffectedFiles();
        }
        if (command instanceof ICommandProxy) {
            return ((ICommandProxy)command).getICommand().getAffectedFiles();
        }
        if (command instanceof CompoundCommand) {
            LinkedHashSet result = new LinkedHashSet();
            Iterator iter = ((CompoundCommand)command).getCommands().iterator();
            while (iter.hasNext()) {
                result.addAll(CommandUtilities.getAffectedFiles((Command)iter.next()));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }
}

