/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.edit.parts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.map.editor.edit.parts.ReferenceInfo2EditPart;
import org.eclipse.gmf.map.editor.edit.policies.ChildReferenceCanonicalEditPolicy;
import org.eclipse.gmf.map.editor.edit.policies.ChildReferenceItemSemanticEditPolicy;
import org.eclipse.gmf.map.editor.part.GMFMapVisualIDRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class ChildReferenceEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 3004;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    public static final Color REFERENCEFIGURE_BACK = new Color(null, 204, 153, 255);

    public ChildReferenceEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ChildReferenceItemSemanticEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ChildReferenceCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        ReferenceFigure figure = new ReferenceFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public ReferenceFigure getPrimaryShape() {
        return (ReferenceFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ReferenceInfo2EditPart) {
            ((ReferenceInfo2EditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureReferenceInfoFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(16), this.getMapMode().DPtoLP(8));
        return result;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        ResizableEditPolicy ep = (ResizableEditPolicy)super.getPrimaryDragEditPolicy();
        ep.setResizeDirections(24);
        return ep;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(GMFMapVisualIDRegistry.getType(5006));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    public class ReferenceFigure
    extends org.eclipse.gmf.map.editor.figures.ReferenceFigure {
        private WrapLabel fReferenceInfoFigure;
        private boolean myUseLocalCoordinates = false;

        public ReferenceFigure() {
            this.setForegroundColor(ColorConstants.darkBlue);
            this.setBackgroundColor(REFERENCEFIGURE_BACK);
            this.setBorder((Border)new MarginBorder(ChildReferenceEditPart.this.getMapMode().DPtoLP(4), ChildReferenceEditPart.this.getMapMode().DPtoLP(0), ChildReferenceEditPart.this.getMapMode().DPtoLP(6), ChildReferenceEditPart.this.getMapMode().DPtoLP(0)));
            this.createContents();
        }

        private void createContents() {
            WrapLabel fig_0 = new WrapLabel();
            this.setFigureReferenceInfoFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public WrapLabel getFigureReferenceInfoFigure() {
            return this.fReferenceInfoFigure;
        }

        private void setFigureReferenceInfoFigure(WrapLabel fig) {
            this.fReferenceInfoFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

