/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.dispatch;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.NoSuchTemplateException;
import org.eclipse.gmf.internal.codegen.dispatch.TemplateRegistry;

public class EmitterFactory {
    private final TemplateRegistry myTemplates;
    private final boolean myUsePrecompiled;
    private final String[] myVariables;
    private final Map myCache;
    private String[] myTemplatePath;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.codegen.dispatch.EmitterFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public EmitterFactory(String[] templatePath, TemplateRegistry templates) {
        this(templatePath, templates, true, null, true);
    }

    public EmitterFactory(String[] templatePath, TemplateRegistry templates, boolean usePrecompiled, String[] variables, boolean cache) {
        if (!($assertionsDisabled || templatePath != null && templatePath.length > 0 && templates != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && variables != null && Arrays.asList(variables).contains(null)) {
            throw new AssertionError();
        }
        this.myTemplatePath = templatePath;
        this.myTemplates = templates;
        this.myUsePrecompiled = usePrecompiled;
        this.myVariables = variables == null ? new String[]{} : variables;
        this.myCache = cache ? this.createCache() : null;
    }

    protected Map createCache() {
        return new HashMap();
    }

    public boolean checkEmitter(Object key) {
        return this.checkCache(key) != null || this.myTemplates.getTemplatePath(key) != null;
    }

    public JETEmitter acquireEmitter(Object key) throws NoSuchTemplateException, UnexpectedBehaviourException {
        JETEmitter em = this.checkCache(key);
        if (em != null) {
            return em;
        }
        em = this.newEmitter(key);
        this.cache(key, em);
        return em;
    }

    public JETEmitter newEmitter(Object key) throws UnexpectedBehaviourException, NoSuchTemplateException {
        String relativePath = this.constructPath(key);
        ClassLoader cl = this.precompiledInUse(key) ? this.myTemplates.getGeneratorClass(key).getClassLoader() : this.myTemplates.getTemplateClassLoader(key);
        JETEmitter em = new JETEmitter(this.myTemplatePath, relativePath, cl);
        this.feedVariables(em);
        this.initPrecompiled(key, em);
        return em;
    }

    private boolean precompiledInUse(Object key) {
        return this.myUsePrecompiled && this.myTemplates.hasGeneratorClass(key);
    }

    private void initPrecompiled(Object key, JETEmitter em) throws UnexpectedBehaviourException {
        block5: {
            try {
                if (!this.precompiledInUse(key)) break block5;
                Class clazz = this.myTemplates.getGeneratorClass(key);
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method m = clazz.getMethod("generate", classArray);
                em.setMethod(m);
            }
            catch (NoSuchMethodException ex) {
                throw new UnexpectedBehaviourException("Bad template class", ex);
            }
        }
    }

    private String constructPath(Object key) throws UnexpectedBehaviourException, NoSuchTemplateException {
        String path = this.myTemplates.getTemplatePath(key);
        if (path == null) {
            throw new NoSuchTemplateException(String.valueOf(key));
        }
        return path;
    }

    private void feedVariables(JETEmitter em) throws UnexpectedBehaviourException {
        try {
            int i = 0;
            while (i < this.myVariables.length) {
                em.addVariable(null, this.myVariables[i]);
                ++i;
            }
        }
        catch (JETException ex) {
            throw new UnexpectedBehaviourException(ex.getMessage(), ex);
        }
    }

    private JETEmitter checkCache(Object key) {
        if (this.myCache != null) {
            return (JETEmitter)this.myCache.get(key);
        }
        return null;
    }

    private void cache(Object key, JETEmitter emitter) {
        if (this.myCache != null) {
            this.myCache.put(key, emitter);
        }
    }
}

