/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui.dashboard;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardAction;
import org.eclipse.gmf.bridge.ui.dashboard.DashboardFacade;
import org.eclipse.gmf.internal.bridge.ui.dashboard.DashboardMediator;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Plugin;
import org.eclipse.ui.PlatformUI;

public class DashboardActionRegistry
implements IExtensionChangeHandler {
    private static String EXTENSIONPOINT_UNIQUE_ID = "org.eclipse.gmf.bridge.ui.dashboard.actions";
    private Set<DashboardMediator> mediators = new HashSet<DashboardMediator>();
    private Set<DashboardActionDescriptor> descriptors = new HashSet<DashboardActionDescriptor>();

    public DashboardActionRegistry() {
        PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSIONPOINT_UNIQUE_ID);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            IExtension[] iExtensionArray = extensions = DashboardActionRegistry.orderExtensions(extensions);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.addDescriptors(extension);
                ++n2;
            }
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint(EXTENSIONPOINT_UNIQUE_ID);
    }

    void registerMediator(DashboardMediator mediator) {
        this.mediators.add(mediator);
    }

    void unregisterMediator(DashboardMediator mediator) {
        this.mediators.remove(mediator);
    }

    public void addExtension(IExtensionTracker tracker, IExtension addedExtension) {
        this.addDescriptors(addedExtension);
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof DashboardActionDescriptor) {
                DashboardActionDescriptor descriptor = (DashboardActionDescriptor)object;
                this.descriptors.remove(descriptor);
                for (DashboardMediator mediator : this.mediators) {
                    mediator.removeDashboardAction(descriptor);
                }
            }
            ++n2;
        }
    }

    public void addDescriptors(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("action")) {
                DashboardActionDescriptor desc = new DashboardActionDescriptor(element);
                this.descriptors.add(desc);
                PlatformUI.getWorkbench().getExtensionTracker().registerObject(element.getDeclaringExtension(), (Object)desc, 0);
                for (DashboardMediator mediator : this.mediators) {
                    mediator.addDashboardAction(desc);
                }
            }
            ++n2;
        }
    }

    public static IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Comparator<IExtension> comparer = new Comparator<IExtension>(){

            @Override
            public int compare(IExtension arg0, IExtension arg1) {
                String s1 = arg0.getNamespaceIdentifier();
                String s2 = arg1.getNamespaceIdentifier();
                return s1.compareToIgnoreCase(s2);
            }
        };
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    public DashboardActionDescriptor[] getDescriptors() {
        return this.descriptors.toArray(new DashboardActionDescriptor[this.descriptors.size()]);
    }

    public static class DashboardActionDescriptor {
        private final IConfigurationElement element;
        private final String label;
        private final String location;
        private final boolean standard;

        public DashboardActionDescriptor(IConfigurationElement element) {
            this.element = element;
            this.label = element.getAttribute("label");
            this.location = element.getAttribute("location");
            this.standard = Boolean.valueOf(element.getAttribute("standard"));
        }

        public IConfigurationElement getElement() {
            return this.element;
        }

        public String getLabel() {
            return this.label;
        }

        public DashboardAction createDashboardAction() {
            return new Proxy();
        }

        public DashboardAction createContributedDashboardAction() {
            try {
                return (DashboardAction)this.element.createExecutableExtension("class");
            }
            catch (Exception e) {
                Plugin.getDefault().getLog().log(Plugin.createError("Unable to create GMF Dashboard action", e));
                return null;
            }
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isStandard() {
            return this.standard;
        }

        private class Proxy
        implements DashboardAction {
            private DashboardFacade context;
            private boolean inited;
            private DashboardAction delegate;
            private boolean notAvailable;

            private Proxy() {
            }

            public void init(DashboardFacade context) {
                this.context = context;
                this.inited = true;
            }

            public boolean isEnabled() {
                if (this.delegate != null) {
                    return this.delegate.isEnabled();
                }
                return !this.notAvailable;
            }

            public void run() {
                if (this.notAvailable) {
                    return;
                }
                if (this.delegate == null) {
                    this.delegate = DashboardActionDescriptor.this.createContributedDashboardAction();
                    if (this.delegate == null) {
                        this.notAvailable = true;
                        return;
                    }
                    if (this.inited) {
                        this.delegate.init(this.context);
                    }
                }
                if (this.delegate.isEnabled()) {
                    this.delegate.run();
                }
            }
        }
    }
}

