/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.properties;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.ForwardUndoCompoundCommand;
import org.eclipse.gmf.runtime.lite.properties.ResetValueCommand;
import org.eclipse.gmf.runtime.lite.properties.RootUndoablePropertySheetEntry;
import org.eclipse.gmf.runtime.lite.properties.SetValueCommand;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetEntry;

class UndoablePropertySheetEntry
extends PropertySheetEntry {
    UndoablePropertySheetEntry() {
    }

    protected PropertySheetEntry createChildEntry() {
        return new UndoablePropertySheetEntry();
    }

    CommandStack getCommandStack() {
        return this.getRoot().getCommandStack();
    }

    RootUndoablePropertySheetEntry getRoot() {
        return ((UndoablePropertySheetEntry)this.getParent()).getRoot();
    }

    public void resetPropertyValue() {
        CompoundCommand cc = new CompoundCommand();
        boolean change = false;
        Object[] objects = this.getParent().getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.getDescriptor().getId())) {
                ResetValueCommand restoreCmd = new ResetValueCommand();
                restoreCmd.setTarget(source);
                restoreCmd.setPropertyId(this.getDescriptor().getId());
                cc.add((Command)restoreCmd);
                change = true;
            }
            ++i;
        }
        if (change) {
            this.getCommandStack().execute((Command)cc);
            this.refreshFromRoot();
        }
    }

    protected void valueChanged(PropertySheetEntry child) {
        this.valueChanged((UndoablePropertySheetEntry)child, (CompoundCommand)new ForwardUndoCompoundCommand());
    }

    private void valueChanged(UndoablePropertySheetEntry child, CompoundCommand command) {
        CompoundCommand cc = new CompoundCommand();
        command.add((Command)cc);
        int i = 0;
        while (i < this.getValues().length) {
            SetValueCommand setCommand = new SetValueCommand(child.getDisplayName());
            setCommand.setTarget(this.getPropertySource(this.getValues()[i]));
            setCommand.setPropertyId(child.getDescriptor().getId());
            setCommand.setPropertyValue(child.getValues()[i]);
            cc.add((Command)setCommand);
            ++i;
        }
        this.informRoot(this, command);
    }

    protected void informRoot(UndoablePropertySheetEntry child, CompoundCommand command) {
        ((UndoablePropertySheetEntry)this.getParent()).valueChanged(this, command);
    }
}

