/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.runtime.lite;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.internal.runtime.lite.Activator;
import org.eclipse.gmf.internal.runtime.lite.RegistryReader;
import org.eclipse.gmf.runtime.lite.commands.CreateNotationalElementCommand;
import org.eclipse.gmf.runtime.lite.shortcuts.IShortcutProvider;
import org.eclipse.gmf.runtime.lite.shortcuts.ShortcutProvidersRegistry;
import org.eclipse.gmf.runtime.notation.View;

public class ShortcutProvidersRegistryImpl
extends ShortcutProvidersRegistry {
    private HashMap<String, IShortcutProvider> myRegistry;
    private RegistryReader myRegistryReader;
    private static final String EXT_POINT = "shortcutProviders";
    private static final String PROVIDER_TAG = "shortcutProvider";
    private static final String CLASS_ATTR = "class";
    private static final String MODEL_ID_ATTR = "modelID";

    public IShortcutProvider getShortcutProvider(String modelID) {
        if (this.myRegistry == null) {
            this.initialize();
        }
        return this.myRegistry.get(modelID);
    }

    public IShortcutProvider[] getShortcutProviders() {
        if (this.myRegistry == null) {
            this.initialize();
        }
        return this.myRegistry.values().toArray(new IShortcutProvider[this.myRegistry.size()]);
    }

    private void initialize() {
        assert (this.myRegistryReader == null);
        this.myRegistry = new HashMap();
        this.myRegistryReader = new RegistryReader(Platform.getExtensionRegistry(), "org.eclipse.gmf.runtime.lite", EXT_POINT){

            protected boolean readElement(IConfigurationElement configurationElement) throws IllegalArgumentException {
                if (ShortcutProvidersRegistryImpl.PROVIDER_TAG.equals(configurationElement.getName())) {
                    Proxy providerProxy = new Proxy(configurationElement);
                    String modelID = providerProxy.getModelID();
                    if (ShortcutProvidersRegistryImpl.this.myRegistry.containsKey(modelID)) {
                        this.logError(configurationElement, MessageFormat.format("Duplicate shortcut provider registration for modelID {0}, ignored", modelID));
                    } else {
                        ShortcutProvidersRegistryImpl.this.myRegistry.put(modelID, providerProxy);
                    }
                }
                return false;
            }

            protected boolean unreadElement(IConfigurationElement configurationElement) {
                if (ShortcutProvidersRegistryImpl.PROVIDER_TAG.equals(configurationElement.getName())) {
                    String modelID = configurationElement.getAttribute(ShortcutProvidersRegistryImpl.MODEL_ID_ATTR);
                    if (ShortcutProvidersRegistryImpl.this.myRegistry.containsKey(modelID)) {
                        ShortcutProvidersRegistryImpl.this.myRegistry.remove(modelID);
                    }
                }
                return false;
            }
        };
        this.myRegistryReader.readRegistry();
    }

    public void dispose() {
        if (this.myRegistryReader != null) {
            this.myRegistryReader.dispose();
            this.myRegistryReader = null;
            this.myRegistry.clear();
            this.myRegistry = null;
        }
    }

    private static class Proxy
    implements IShortcutProvider {
        private IShortcutProvider myDelegate;
        private IConfigurationElement myDescriptor;

        public Proxy(IConfigurationElement descriptor) {
            this.myDescriptor = descriptor;
        }

        public String getModelID() {
            return this.myDescriptor.getAttribute(ShortcutProvidersRegistryImpl.MODEL_ID_ATTR);
        }

        private void load() {
            if (this.myDelegate == null) {
                try {
                    this.myDelegate = (IShortcutProvider)this.myDescriptor.createExecutableExtension(ShortcutProvidersRegistryImpl.CLASS_ATTR);
                }
                catch (Throwable e) {
                    Activator.getDefault().logError("Exception occurred while instantiating shortcut provider, provider will be disabled", e);
                    this.myDelegate = Stub.INSTANCE;
                }
            }
        }

        public EditPart createShortcutEditPart(EditPart context, View shortcutView) {
            this.load();
            return this.myDelegate.createShortcutEditPart(context, shortcutView);
        }

        public CreateNotationalElementCommand getCreateShortcutCommand(View containerView, EObject underlyingModelObject) {
            this.load();
            return this.myDelegate.getCreateShortcutCommand(containerView, underlyingModelObject);
        }

        public Command getRefreshShortcutCommand(View shortcut) {
            this.load();
            return this.myDelegate.getRefreshShortcutCommand(shortcut);
        }
    }

    private static class Stub
    implements IShortcutProvider {
        public static final Stub INSTANCE = new Stub();

        private Stub() {
        }

        public EditPart createShortcutEditPart(EditPart context, View shortcutView) {
            return null;
        }

        public CreateNotationalElementCommand getCreateShortcutCommand(View containerView, EObject underlyingModelObject) {
            return null;
        }

        public Command getRefreshShortcutCommand(View shortcut) {
            return null;
        }
    }
}

