/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.SuppressibleUIRequest;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;

public class DeferredCreateConnectionViewAndElementCommand
extends AbstractCommand {
    CreateRequest request = null;
    IAdaptable typeInfoAdapter = null;
    IAdaptable sourceViewAdapter = null;
    IAdaptable targetViewAdapter = null;
    Command command = null;
    EditPartViewer viewer = null;

    private DeferredCreateConnectionViewAndElementCommand(IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer) {
        super(DiagramUIMessages.Commands_CreateCommand_Connection_Label, null);
        Assert.isNotNull((Object)currentViewer, (String)"currentViewer is null");
        this.sourceViewAdapter = sourceViewAdapter;
        this.targetViewAdapter = targetViewAdapter;
        this.viewer = currentViewer;
    }

    public DeferredCreateConnectionViewAndElementCommand(CreateConnectionViewAndElementRequest request, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer) {
        this(sourceViewAdapter, targetViewAdapter, currentViewer);
        this.request = request;
    }

    public DeferredCreateConnectionViewAndElementCommand(IElementType type, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer, PreferencesHint preferencesHint) {
        this(new CreateConnectionViewAndElementRequest(type, preferencesHint), sourceViewAdapter, targetViewAdapter, currentViewer);
    }

    public DeferredCreateConnectionViewAndElementCommand(CreateRequest request, IAdaptable typeInfoAdapter, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer currentViewer) {
        this(sourceViewAdapter, targetViewAdapter, currentViewer);
        this.request = request;
        this.typeInfoAdapter = typeInfoAdapter;
    }

    public List getAffectedFiles() {
        View view;
        EditPart editpart;
        if (this.viewer != null && (editpart = this.viewer.getRootEditPart().getContents()) instanceof IGraphicalEditPart && (view = (View)editpart.getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    public boolean canRedo() {
        return CommandUtilities.canRedo(this.command);
    }

    protected EditPart getSourceEditPart() {
        return (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(this.sourceViewAdapter.getAdapter(View.class));
    }

    protected EditPart getTargetEditPart() {
        return (IGraphicalEditPart)this.viewer.getEditPartRegistry().get(this.targetViewAdapter.getAdapter(View.class));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CreateConnectionViewRequest req = null;
        if (this.request != null) {
            if (this.request instanceof CreateConnectionViewRequest) {
                req = (CreateConnectionViewRequest)this.request;
            }
        } else {
            return CommandResult.newErrorCommandResult((String)this.getLabel());
        }
        if (this.typeInfoAdapter != null) {
            IElementType typeInfo = (IElementType)this.typeInfoAdapter.getAdapter(IElementType.class);
            if (typeInfo == null) {
                CommandResult.newErrorCommandResult((String)this.getLabel());
            }
            if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
                req = (CreateConnectionViewRequest)((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(typeInfo);
            }
        }
        req.setLocation(null);
        if (this.targetViewAdapter.getAdapter(IGraphicalEditPart.class) == null && req instanceof SuppressibleUIRequest) {
            ((SuppressibleUIRequest)((Object)req)).setSuppressibleUI(true);
        }
        EditPart sourceEP = this.getSourceEditPart();
        EditPart targetEP = this.getTargetEditPart();
        if (sourceEP == null || targetEP == null) {
            return null;
        }
        this.command = req instanceof CreateConnectionViewAndElementRequest ? CreateConnectionViewAndElementRequest.getCreateCommand(req, sourceEP, targetEP) : CreateConnectionViewRequest.getCreateCommand(req, sourceEP, targetEP);
        if (this.command != null && this.command.canExecute()) {
            this.command.execute();
        }
        this.viewer = null;
        View view = (View)req.getConnectionViewDescriptor().getAdapter(View.class);
        if (view == null) {
            return CommandResult.newCancelledCommandResult();
        }
        return CommandResult.newOKCommandResult((Object)req.getNewObject());
    }

    public String getLabel() {
        if (this.command != null) {
            return this.command.getLabel();
        }
        return null;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.command != null) {
            this.command.undo();
        }
        return CommandResult.newOKCommandResult();
    }
}

