/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListLiteral
extends Expression {
    private Expression[] elements;

    public ListLiteral(int start, int end, int line, Expression[] contents) {
        super(start, end, line);
        this.elements = contents;
    }

    public Expression[] getElements() {
        return this.elements;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Expression[] params;
        ArrayList<Object> col = new ArrayList<Object>();
        Expression[] expressionArray = params = this.getElements();
        int n = 0;
        int n2 = expressionArray.length;
        while (n < n2) {
            Expression element = expressionArray[n];
            col.add(element.evaluate(ctx));
            ++n;
        }
        return col;
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier commonDenominator = null;
        Expression[] expressionArray = this.elements;
        int n = 0;
        int n2 = expressionArray.length;
        while (n < n2) {
            Expression element = expressionArray[n];
            EClassifier exprType = element.analyze(ctx, issues);
            if (exprType == null) {
                return null;
            }
            if (commonDenominator == null) {
                commonDenominator = exprType;
            } else if (BuiltinMetaModel.isAssignableFrom(exprType, commonDenominator)) {
                commonDenominator = exprType;
            } else if (!BuiltinMetaModel.isAssignableFrom(commonDenominator, exprType)) {
                commonDenominator = EcorePackage.eINSTANCE.getEJavaObject();
            }
            ++n;
        }
        return BuiltinMetaModel.getListType(commonDenominator);
    }

    public String toString() {
        return "{" + this.expressionsToString() + "}";
    }

    private String expressionsToString() {
        String r = "";
        int i = 0;
        while (i < this.elements.length) {
            r = String.valueOf(r) + this.elements[i].toString();
            if (i + 1 < this.elements.length) {
                r = String.valueOf(r) + ",";
            }
            ++i;
        }
        return r;
    }
}

