/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cast
extends Expression {
    private Identifier type;
    private Expression target;

    public Cast(int start, int end, int line, Identifier type, Expression target) {
        super(start, end, line);
        this.type = type;
        this.target = target;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Identifier getType() {
        return this.type;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        return this.getTarget().evaluate(ctx);
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = this.getTarget().analyze(ctx, issues);
        EClassifier toCast = this.findType(this.getType(), ctx, issues);
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, this.getType().getValue(), this.getType()));
            return null;
        }
        if (t == null) {
            return null;
        }
        if (BuiltinMetaModel.isParameterizedType(t) && BuiltinMetaModel.isParameterizedType(toCast)) {
            if (BuiltinMetaModel.isAssignableFrom(t, toCast)) {
                EClassifier innerEClassifier = this.getCastedType(BuiltinMetaModel.getInnerType(t), BuiltinMetaModel.getInnerType(toCast));
                if (innerEClassifier == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
                    return null;
                }
                return BuiltinMetaModel.cloneParametrizedType(toCast, innerEClassifier);
            }
            if (BuiltinMetaModel.isAssignableFrom(toCast, t)) {
                EClassifier innerEClassifier = this.getCastedType(BuiltinMetaModel.getInnerType(t), BuiltinMetaModel.getInnerType(toCast));
                if (innerEClassifier == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
                    return null;
                }
                return BuiltinMetaModel.cloneParametrizedType(t, innerEClassifier);
            }
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
            return null;
        }
        EClassifier rt = this.getCastedType(t, toCast);
        if (rt == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
        }
        return rt;
    }

    private EClassifier getCastedType(EClassifier typeA, EClassifier typeB) {
        EDataType objEClassifier = EcorePackage.eINSTANCE.getEJavaObject();
        if (typeA == null || typeA == BuiltinMetaModel.VOID) {
            typeA = objEClassifier;
        }
        if (typeB == null || typeA == BuiltinMetaModel.VOID) {
            typeB = objEClassifier;
        }
        if (BuiltinMetaModel.isAssignableFrom(typeA, typeB)) {
            return typeB;
        }
        if (BuiltinMetaModel.isAssignableFrom(typeB, typeA)) {
            return typeA;
        }
        return null;
    }

    public String toString() {
        return "(" + this.type.getValue() + ")" + this.target.toString();
    }
}

