/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.CommonUIServicesActionPlugin;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IPopupMenuContributionPolicy;
import org.eclipse.gmf.runtime.common.ui.util.IPartSelector;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IMarkSelection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ProviderContributionDescriptor
extends AbstractProviderConfiguration {
    private static final String PART_CONTRIBUTION = "partContribution";
    private static final String PART_MENU_CONTRIBUTION = "partMenu";
    private static final String PART_MENUGROUP_CONTRIBUTION = "partMenuGroup";
    private static final String PART_ACTION_CONTRIBUTION = "partAction";
    private static final String PART_ACTIONGROUP_CONTRIBUTION = "partActionGroup";
    private static final String PART_CUSTOM_CONTRIBUTION = "partCustom";
    private static final String POPUP_CONTRIBUTION = "popupContribution";
    private static final String POPUP_MENU_CONTRIBUTION = "popupMenu";
    private static final String POPUP_MENUGROUP_CONTRIBUTION = "popupMenuGroup";
    private static final String POPUP_ACTION_CONTRIBUTION = "popupAction";
    private static final String POPUP_ACTIONGROUP_CONTRIBUTION = "popupActionGroup";
    private static final String POPUP_CUSTOM_CONTRIBUTION = "popupCustom";
    private static final String POPUP_PREDEFINED_ITEM = "popupPredefinedItem";
    private static final String STRUCTURED_CRITERIA = "popupStructuredContributionCriteria";
    private static final String TEXT_CRITERIA = "popupTextContributionCriteria";
    private static final String MARK_CRITERIA = "popupMarkContributionCriteria";
    private static final String CONTRIBUTION_ID = "id";
    private static final String CONTRIBUTION_TOOLBAR_PATH = "toolbarPath";
    private static final String CONTRIBUTION_MENUBAR_PATH = "menubarPath";
    private static final String CONTRIBUTION_PATH = "path";
    private static final String MENUGROUP_SEPARATOR = "separator";
    private static final String OBJECT_CLASS = "objectClass";
    private static final String OBJECT_COUNT = "objectCount";
    private static final String POLICY_CLASS = "policyClass";
    private static final String GLOBAL = "global";
    private static final String TEXT = "text";
    private static final String DOCUMENT_CLASS = "documentClass";
    private static final String REMOVE = "remove";
    private List partContributions = new ArrayList();
    private List popupContributions = new ArrayList();

    private ProviderContributionDescriptor(IConfigurationElement configElement) {
        IConfigurationElement[] configChildren = configElement.getChildren();
        if (configChildren.length <= 1) {
            Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The contribution item provider has zero contributions");
        }
        int i = 1;
        while (i < configChildren.length) {
            if (configChildren[i].getName().equals(PART_CONTRIBUTION)) {
                this.partContributions.add(new PartContributionDescriptor(configChildren[i]));
            } else if (configChildren[i].getName().equals(POPUP_CONTRIBUTION)) {
                this.popupContributions.add(new PopupContributionDescriptor(configChildren[i]));
            }
            ++i;
        }
    }

    public static ProviderContributionDescriptor parse(IConfigurationElement configElement) {
        assert (configElement != null) : "null provider configuration element";
        return new ProviderContributionDescriptor(configElement);
    }

    public boolean hasContributions() {
        return !this.partContributions.isEmpty() || !this.popupContributions.isEmpty();
    }

    public boolean hasContributionsFor(String partId, Class partClass) {
        assert (partId != null) : "null part id";
        assert (partClass != null) : "null part class";
        for (PartContributionDescriptor contribution : this.partContributions) {
            if (!contribution.appliesTo(partId, partClass)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContributionsFor(IMenuManager popupMenu, ISelection selection) {
        assert (popupMenu != null) : "null popupMenu";
        assert (selection != null) : "null selection";
        String popupId = popupMenu.getId();
        Class<?> popupClass = popupMenu.getClass();
        for (PopupContributionDescriptor contribution : this.popupContributions) {
            if (!contribution.appliesTo(popupId, popupClass, selection)) continue;
            return true;
        }
        return false;
    }

    public List getContributionsFor(String partId, Class partClass) {
        assert (partId != null) : "null part id";
        assert (partClass != null) : "null part class";
        ArrayList contributions = new ArrayList();
        for (PartContributionDescriptor contribution : this.partContributions) {
            if (!contribution.appliesTo(partId, partClass)) continue;
            contributions.addAll(contribution.getContributionItems());
        }
        return contributions;
    }

    public List getContributionsFor(IMenuManager popupMenu, ISelection selection) {
        assert (popupMenu != null) : "null popupMenu";
        assert (selection != null) : "null selection";
        ArrayList contributions = new ArrayList();
        for (PopupContributionDescriptor contribution : this.popupContributions) {
            if (!contribution.appliesTo(popupMenu.getId(), popupMenu.getClass(), selection)) continue;
            contributions.addAll(contribution.getContributionItems());
        }
        return contributions;
    }

    static /* synthetic */ boolean access$0(Class clazz, String string) {
        return AbstractProviderConfiguration.isAssignableTo((Class)clazz, (String)string);
    }

    private static abstract class AbstractContributionDescriptor {
        private final String targetId;
        private final String targetClassName;
        private List contributionItems = new ArrayList();

        public AbstractContributionDescriptor(IConfigurationElement configElement) {
            this.targetId = configElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_ID);
            this.targetClassName = configElement.getAttribute("class");
            if (this.targetId == null && this.targetClassName == null) {
                Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"Both the target id and class are missing for the contribution");
            }
        }

        protected boolean appliesTo(String sourceId, Class sourceClass) {
            if (this.targetId != null && sourceId != null) {
                return this.targetId.equals(sourceId);
            }
            if (this.targetClassName != null && sourceClass != null) {
                return ProviderContributionDescriptor.access$0(sourceClass, this.targetClassName);
            }
            return false;
        }

        public List getContributionItems() {
            return this.contributionItems;
        }
    }

    private static class PartContributionDescriptor
    extends AbstractContributionDescriptor {
        public PartContributionDescriptor(IConfigurationElement configElement) {
            super(configElement);
            IConfigurationElement[] configChildren = configElement.getChildren();
            if (configChildren.length <= 0) {
                Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The part contribution has zero contribution items");
            }
            int i = 0;
            while (i < configChildren.length) {
                String contributionType = configChildren[i].getName();
                if (contributionType.equals(ProviderContributionDescriptor.PART_MENU_CONTRIBUTION)) {
                    this.getContributionItems().add(new PartMenuDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.PART_MENUGROUP_CONTRIBUTION)) {
                    this.getContributionItems().add(new PartMenuGroupDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.PART_ACTION_CONTRIBUTION)) {
                    this.getContributionItems().add(new PartActionDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.PART_CUSTOM_CONTRIBUTION)) {
                    this.getContributionItems().add(new PartCustomDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.PART_ACTIONGROUP_CONTRIBUTION)) {
                    this.getContributionItems().add(new PartActionGroupDescriptor(configChildren[i]));
                }
                ++i;
            }
        }

        public boolean appliesTo(String sourceId, Class sourceClass) {
            return super.appliesTo(sourceId, sourceClass);
        }
    }

    private static class PopupContributionDescriptor
    extends AbstractContributionDescriptor {
        private PopupContributionCriteria[] criteria;

        public PopupContributionDescriptor(IConfigurationElement configElement) {
            super(configElement);
            this.criteria = this.readCriteria(configElement);
            IConfigurationElement[] configChildren = configElement.getChildren();
            if (configChildren.length <= 0) {
                Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The part contribution has zero contribution items");
            }
            int i = 0;
            while (i < configChildren.length) {
                String contributionType = configChildren[i].getName();
                if (contributionType.equals(ProviderContributionDescriptor.POPUP_MENU_CONTRIBUTION)) {
                    this.getContributionItems().add(new PopupMenuDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.POPUP_MENUGROUP_CONTRIBUTION)) {
                    this.getContributionItems().add(new PopupMenuGroupDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.POPUP_ACTION_CONTRIBUTION)) {
                    this.getContributionItems().add(new PopupActionDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.POPUP_CUSTOM_CONTRIBUTION)) {
                    this.getContributionItems().add(new PopupCustomDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.POPUP_ACTIONGROUP_CONTRIBUTION)) {
                    this.getContributionItems().add(new PopupActionGroupDescriptor(configChildren[i]));
                } else if (contributionType.equals(ProviderContributionDescriptor.POPUP_PREDEFINED_ITEM)) {
                    this.getContributionItems().add(new PopupPredefinedItemDescriptor(configChildren[i]));
                }
                ++i;
            }
        }

        protected PopupContributionCriteria[] readCriteria(IConfigurationElement configElement) {
            IConfigurationElement[] criteriaEl = configElement.getChildren(ProviderContributionDescriptor.STRUCTURED_CRITERIA);
            if (criteriaEl.length > 0) {
                PopupContributionCriteria[] pcc = new PopupContributionCriteria[criteriaEl.length];
                int i = 0;
                while (i < criteriaEl.length) {
                    pcc[i] = new PopupStructuredContributionCriteria(criteriaEl[i]);
                    ++i;
                }
                return pcc;
            }
            criteriaEl = configElement.getChildren(ProviderContributionDescriptor.TEXT_CRITERIA);
            if (criteriaEl.length > 0) {
                PopupContributionCriteria[] pcc = new PopupContributionCriteria[criteriaEl.length];
                int i = 0;
                while (i < criteriaEl.length) {
                    pcc[i] = new PopupTextContributionCriteria(criteriaEl[i]);
                    ++i;
                }
                return pcc;
            }
            criteriaEl = configElement.getChildren(ProviderContributionDescriptor.MARK_CRITERIA);
            if (criteriaEl.length > 0) {
                PopupContributionCriteria[] pcc = new PopupContributionCriteria[criteriaEl.length];
                int i = 0;
                while (i < criteriaEl.length) {
                    pcc[i] = new PopupMarkContributionCriteria(criteriaEl[i]);
                    ++i;
                }
                return pcc;
            }
            return null;
        }

        public boolean appliesTo(String sourceId, Class sourceClass, ISelection selection) {
            if (!this.appliesTo(sourceId, sourceClass)) {
                return false;
            }
            return this.criteria == null || this.isCriteriaMet(selection);
        }

        protected boolean isCriteriaMet(ISelection selection) {
            int i = 0;
            while (i < this.criteria.length) {
                if (this.criteria[i].appliesTo(selection)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static abstract class AbstractContributionItemDescriptor {
        private String id;

        public AbstractContributionItemDescriptor(IConfigurationElement configElement) {
            this.id = configElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_ID);
            assert (this.id != null) : "The contribution item's id is missing";
        }

        public String getId() {
            return this.id;
        }

        protected static String extractMenuPath(String location) {
            int loc;
            if (location != null && (loc = location.lastIndexOf(47)) != -1) {
                return location.substring(0, loc == 0 ? 1 : loc);
            }
            return null;
        }

        protected static String extractGroup(String location) {
            int loc;
            if (location != null && (loc = location.lastIndexOf(47)) != -1) {
                return location.substring(loc + 1);
            }
            return null;
        }
    }

    private static abstract class AbstractPartContributionItemDescriptor
    extends AbstractContributionItemDescriptor
    implements IPartSelector {
        private String menubarPath;
        private String menubarGroup;
        private String toolbarPath;
        private String toolbarGroup;
        private String targetId;
        private String targetClassName;

        public AbstractPartContributionItemDescriptor(IConfigurationElement configElement) {
            super(configElement);
            Object parent;
            String location = configElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_MENUBAR_PATH);
            if (location != null) {
                this.menubarPath = AbstractPartContributionItemDescriptor.extractMenuPath(location);
                this.menubarGroup = AbstractPartContributionItemDescriptor.extractGroup(location);
            }
            if ((location = configElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_TOOLBAR_PATH)) != null) {
                this.toolbarPath = AbstractPartContributionItemDescriptor.extractMenuPath(location);
                this.toolbarGroup = AbstractPartContributionItemDescriptor.extractGroup(location);
            }
            if ((parent = configElement.getParent()) instanceof IConfigurationElement) {
                IConfigurationElement parentElement = (IConfigurationElement)parent;
                this.targetId = parentElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_ID);
                this.targetClassName = parentElement.getAttribute("class");
            }
        }

        public String getMenubarPath() {
            return this.menubarPath;
        }

        public String getMenubarGroup() {
            return this.menubarGroup;
        }

        public String getToolbarPath() {
            return this.toolbarPath;
        }

        public String getToolbarGroup() {
            return this.toolbarGroup;
        }

        public boolean selects(IWorkbenchPart part) {
            IWorkbenchPartSite site = part.getSite();
            if (site != null) {
                String partId = site.getId();
                if (this.targetId != null && partId != null) {
                    return this.targetId.equals(partId);
                }
            }
            Class<?> partClass = part.getClass();
            if (this.targetClassName != null && partClass != null) {
                return ProviderContributionDescriptor.access$0(partClass, this.targetClassName);
            }
            return false;
        }
    }

    public static abstract class AbstractPopupContributionItemDescriptor
    extends AbstractContributionItemDescriptor
    implements IPartSelector {
        private String path;
        private String group;

        public AbstractPopupContributionItemDescriptor(IConfigurationElement configElement) {
            super(configElement);
            String location = configElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_PATH);
            if (location != null) {
                this.path = AbstractPopupContributionItemDescriptor.extractMenuPath(location);
                this.group = AbstractPopupContributionItemDescriptor.extractGroup(location);
            } else {
                this.path = "/";
                this.group = "additionsGroup";
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getGroup() {
            return this.group;
        }

        public boolean selects(IWorkbenchPart part) {
            return false;
        }
    }

    public static class PartMenuDescriptor
    extends AbstractPartContributionItemDescriptor {
        public PartMenuDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PartMenuGroupDescriptor
    extends AbstractPartContributionItemDescriptor {
        private Boolean separator;

        public PartMenuGroupDescriptor(IConfigurationElement configElement) {
            super(configElement);
            String sep = configElement.getAttribute(ProviderContributionDescriptor.MENUGROUP_SEPARATOR);
            this.separator = sep == null ? Boolean.TRUE : Boolean.valueOf(sep);
        }

        public boolean isSeparator() {
            return this.separator;
        }
    }

    public static class PartActionDescriptor
    extends AbstractPartContributionItemDescriptor {
        private Boolean isGlobal;

        public PartActionDescriptor(IConfigurationElement configElement) {
            super(configElement);
            String global = configElement.getAttribute(ProviderContributionDescriptor.GLOBAL);
            this.isGlobal = global == null ? Boolean.FALSE : Boolean.valueOf(global);
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }
    }

    public static class PartActionGroupDescriptor
    extends AbstractPartContributionItemDescriptor {
        public PartActionGroupDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PartCustomDescriptor
    extends AbstractPartContributionItemDescriptor {
        public PartCustomDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PopupMenuDescriptor
    extends AbstractPopupContributionItemDescriptor {
        public PopupMenuDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PopupMenuGroupDescriptor
    extends AbstractPopupContributionItemDescriptor {
        private Boolean separator;

        public PopupMenuGroupDescriptor(IConfigurationElement configElement) {
            super(configElement);
            String sep = configElement.getAttribute(ProviderContributionDescriptor.MENUGROUP_SEPARATOR);
            this.separator = sep == null ? Boolean.TRUE : Boolean.valueOf(sep);
        }

        public boolean isSeparator() {
            return this.separator;
        }
    }

    public static class PopupActionDescriptor
    extends AbstractPopupContributionItemDescriptor {
        public PopupActionDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PopupActionGroupDescriptor
    extends AbstractPopupContributionItemDescriptor {
        public PopupActionGroupDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PopupCustomDescriptor
    extends AbstractPopupContributionItemDescriptor {
        public PopupCustomDescriptor(IConfigurationElement configElement) {
            super(configElement);
        }
    }

    public static class PopupPredefinedItemDescriptor
    extends AbstractContributionItemDescriptor {
        private String path;
        private boolean remove;

        public PopupPredefinedItemDescriptor(IConfigurationElement configElement) {
            super(configElement);
            String location = configElement.getAttribute(ProviderContributionDescriptor.CONTRIBUTION_PATH);
            this.path = location == null ? "/" : PopupPredefinedItemDescriptor.extractMenuPath(location);
            this.remove = Boolean.valueOf(configElement.getAttribute(ProviderContributionDescriptor.REMOVE));
        }

        public String getPath() {
            return this.path;
        }

        public boolean isToBeRemoved() {
            return this.remove;
        }
    }

    private static class PopupContributionCriteria {
        private IConfigurationElement configElement;
        private String policyClassName;
        private IPopupMenuContributionPolicy policy = null;

        public PopupContributionCriteria(IConfigurationElement configElement) {
            this.configElement = configElement;
            this.policyClassName = configElement.getAttribute(ProviderContributionDescriptor.POLICY_CLASS);
        }

        public boolean appliesTo(ISelection selection) {
            IPopupMenuContributionPolicy thePolicy;
            return this.policyClassName == null || (thePolicy = this.getPolicy()) != null && thePolicy.appliesTo(selection, this.configElement);
        }

        protected IPopupMenuContributionPolicy getPolicy() {
            if (this.policy == null) {
                try {
                    Object extension = this.configElement.createExecutableExtension(this.policyClassName);
                    if (extension instanceof IPopupMenuContributionPolicy) {
                        this.policy = (IPopupMenuContributionPolicy)extension;
                    } else {
                        Log.info((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)4, (String)"The supplied policy class name does not implement IPopupMenuContributionPolicy");
                    }
                }
                catch (CoreException ce) {
                    Trace.catching((Plugin)CommonUIServicesActionPlugin.getDefault(), (String)CommonUIServicesActionDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getPolicy", (Throwable)ce);
                    Log.log((Plugin)CommonUIServicesActionPlugin.getDefault(), (int)ce.getStatus().getSeverity(), (int)4, (String)ce.getStatus().getMessage(), (Throwable)ce.getStatus().getException());
                }
            }
            return this.policy;
        }
    }

    private static class PopupStructuredContributionCriteria
    extends PopupContributionCriteria {
        private AbstractProviderConfiguration.ObjectDescriptor object;
        private Integer targetCount;
        private boolean orHigher;

        public PopupStructuredContributionCriteria(IConfigurationElement configElement) {
            super(configElement);
            this.object = new AbstractProviderConfiguration.ObjectDescriptor(configElement, ProviderContributionDescriptor.OBJECT_CLASS);
            String countStr = configElement.getAttribute(ProviderContributionDescriptor.OBJECT_COUNT);
            this.orHigher = false;
            if (countStr != null) {
                if (countStr.equals("*")) {
                    this.targetCount = Integer.valueOf("0");
                    this.orHigher = true;
                } else if (countStr.equals("+")) {
                    this.targetCount = Integer.valueOf("1");
                    this.orHigher = true;
                } else {
                    int plusIndex = countStr.lastIndexOf("+");
                    if (plusIndex > 0) {
                        this.orHigher = true;
                        countStr = countStr.substring(0, plusIndex);
                    }
                    try {
                        this.targetCount = Integer.valueOf(countStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.orHigher = true;
                        this.targetCount = Integer.valueOf("1");
                    }
                }
            }
        }

        public boolean appliesTo(ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return false;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator objects = structuredSelection.iterator();
            while (objects.hasNext()) {
                if (this.object.sameAs(objects.next())) continue;
                return false;
            }
            if (this.targetCount != null && (this.orHigher ? structuredSelection.size() < this.targetCount : structuredSelection.size() != this.targetCount.intValue())) {
                return false;
            }
            return super.appliesTo(selection);
        }
    }

    private static class PopupTextContributionCriteria
    extends PopupContributionCriteria {
        private String text;

        public PopupTextContributionCriteria(IConfigurationElement configElement) {
            super(configElement);
            this.text = configElement.getAttribute(ProviderContributionDescriptor.TEXT);
        }

        public boolean appliesTo(ISelection selection) {
            if (!(selection instanceof ITextSelection)) {
                return false;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            if (this.text != null && !this.text.equals(textSelection.getText())) {
                return false;
            }
            return super.appliesTo(selection);
        }
    }

    private static class PopupMarkContributionCriteria
    extends PopupContributionCriteria {
        private AbstractProviderConfiguration.ObjectDescriptor document;

        public PopupMarkContributionCriteria(IConfigurationElement configElement) {
            super(configElement);
            this.document = new AbstractProviderConfiguration.ObjectDescriptor(configElement, ProviderContributionDescriptor.DOCUMENT_CLASS);
        }

        public boolean appliesTo(ISelection selection) {
            if (!(selection instanceof IMarkSelection)) {
                return false;
            }
            IMarkSelection markSelection = (IMarkSelection)selection;
            if (!this.document.sameAs((Object)markSelection.getDocument())) {
                return false;
            }
            return super.appliesTo(selection);
        }
    }
}

