/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorUtil;
import org.eclipse.gmf.ecore.part.EcoreVisualIDRegistry;
import org.eclipse.gmf.ecore.part.ModelElementSelectionPage;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class EcoreNewDiagramFileWizard
extends Wizard {
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;
    private TransactionalEditingDomain myEditingDomain;

    public EcoreNewDiagramFileWizard(URI domainModelURI, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        Path filePath;
        assert (domainModelURI != null) : "Domain model uri must be specified";
        assert (diagramRoot != null) : "Doagram root element must be specified";
        assert (editingDomain != null) : "Editing domain must be specified";
        this.myFileCreationPage = new WizardNewFileCreationPage("Initialize new diagram file", (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle("Diagram file");
        this.myFileCreationPage.setDescription("Create new diagram based on Ecore model content");
        String fileName = domainModelURI.trimFileExtension().lastSegment();
        if (domainModelURI.isPlatformResource()) {
            filePath = new Path(domainModelURI.trimSegments(1).toPlatformString(true));
        } else if (domainModelURI.isFile()) {
            filePath = new Path(domainModelURI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + domainModelURI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)filePath);
        this.myFileCreationPage.setFileName(EcoreDiagramEditorUtil.getUniqueFileName((IPath)filePath, fileName, "ecore_diagram"));
        this.diagramRootElementSelectionPage = new DiagramRootElementSelectionPage("Select diagram root element");
        this.diagramRootElementSelectionPage.setTitle("Diagram root element");
        this.diagramRootElementSelectionPage.setDescription("Select semantic model element to be depicted on diagram");
        this.diagramRootElementSelectionPage.setModelElement(diagramRoot);
        this.myEditingDomain = editingDomain;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myFileCreationPage);
        this.addPage((IWizardPage)this.diagramRootElementSelectionPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        IFile diagramFile = this.myFileCreationPage.createNewFile();
        EcoreDiagramEditorUtil.setCharset(diagramFile);
        affectedFiles.add(diagramFile);
        URI diagramModelURI = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(diagramModelURI);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, "Initializing diagram contents", affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = EcoreVisualIDRegistry.getDiagramVisualID(EcoreNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement());
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)"Incorrect model object stored as a root resource object");
                }
                Diagram diagram = ViewService.createDiagram((EObject)EcoreNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement(), (String)"Ecore", (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(EcoreDiagramEditorUtil.getSaveOptions());
            EcoreDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            EcoreDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramModelURI, ex);
        }
        catch (PartInitException ex) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }

    private static class DiagramRootElementSelectionPage
    extends ModelElementSelectionPage {
        protected DiagramRootElementSelectionPage(String pageName) {
            super(pageName);
        }

        protected String getSelectionTitle() {
            return "Select diagram root element:";
        }

        protected boolean validatePage() {
            if (this.selectedModelElement == null) {
                this.setErrorMessage("Diagram root element is not selected");
                return false;
            }
            boolean result = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(this.selectedModelElement), "Ecore", EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(result ? null : "Invalid diagram root element is selected");
            return result;
        }
    }
}

