/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.common.ToolingResourceFactory;
import org.eclipse.gmf.internal.common.migrate.MigrationResource;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;

public class MigrationUtil {
    private MigrationUtil() {
    }

    public static ModelLoadHelper migrateModel(URI modelResourceURI) {
        if (modelResourceURI == null) {
            throw new IllegalArgumentException("null resource uri");
        }
        ResourceSetImpl rset = new ResourceSetImpl();
        rset.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistryImpl(){

            public Resource.Factory getFactory(URI uri) {
                return new ToolingResourceFactory(){

                    public Resource createResource(URI uri) {
                        return new MigrationResource(uri);
                    }
                };
            }
        });
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)rset, modelResourceURI);
        return loadHelper;
    }

    public static MigrationDiagnostic createMessageDiagnostic(Resource resource, final String message) {
        final String location = resource.getURI() == null ? null : resource.getURI().toString();
        return new MigrationDiagnostic(){

            public String getMessage() {
                return message;
            }

            public String getLocation() {
                return location;
            }

            public int getColumn() {
                return 0;
            }

            public int getLine() {
                return 0;
            }
        };
    }

    public static interface MigrationDiagnostic
    extends Resource.Diagnostic {
    }
}

