/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gmf.internal.bridge.ui.Plugin;

public class TransformOptions
extends AbstractPreferenceInitializer {
    private static final String PREF_GENERATE_RCP = "generate_rcp";
    private static final String PREF_USE_MAP_MODE = "use_map_mode";
    private static final String PREF_USE_RUNTIME_FIGURES = "use_runtime_figures";
    private static final String PREF_IGNORE_MAPMODEL_VALIDATION = "ignore_mapmodel_validation";
    private static final String PREF_FIGURE_TEMPLATES = "dynamic_figure_templates";
    private static String[] PROP_NAMES = new String[]{"generate_rcp", "use_map_mode", "use_runtime_figures", "ignore_mapmodel_validation", "dynamic_figure_templates"};
    private Preferences myPreferences;

    public TransformOptions() {
        this.reset();
    }

    private Preferences getPreferences() {
        if (this.myPreferences == null) {
            this.myPreferences = new Preferences();
        }
        return this.myPreferences;
    }

    public void reset() {
        Preferences pluginPrefs = Plugin.getDefault().getPluginPreferences();
        this.copyPreferences(pluginPrefs, this.getPreferences());
    }

    public void flush() {
        Preferences pluginPrefs = Plugin.getDefault().getPluginPreferences();
        this.copyPreferences(this.getPreferences(), pluginPrefs);
        Plugin.getDefault().savePluginPreferences();
    }

    private void copyPreferences(Preferences source, Preferences target) {
        String[] stringArray = PROP_NAMES;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String name = stringArray[n];
            target.setValue(name, source.getString(name));
            ++n;
        }
    }

    public boolean getGenerateRCP() {
        return this.getPreferences().getBoolean(PREF_GENERATE_RCP);
    }

    public boolean getUseMapMode() {
        return this.getPreferences().getBoolean(PREF_USE_MAP_MODE);
    }

    public boolean getUseRuntimeFigures() {
        return this.getPreferences().getBoolean(PREF_USE_RUNTIME_FIGURES);
    }

    public boolean getIgnoreMapModelValidation() {
        return this.getPreferences().getBoolean(PREF_IGNORE_MAPMODEL_VALIDATION);
    }

    public URL getFigureTemplatesPath() {
        String value = this.getPreferences().getString(PREF_FIGURE_TEMPLATES);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException ex) {
            Plugin.log(ex);
            return null;
        }
    }

    public void setGenerateRCP(boolean value) {
        this.getPreferences().setValue(PREF_GENERATE_RCP, value);
    }

    public void setUseMapMode(boolean value) {
        this.getPreferences().setValue(PREF_USE_MAP_MODE, value);
    }

    public void setUseRuntimeFigures(boolean value) {
        this.getPreferences().setValue(PREF_USE_RUNTIME_FIGURES, value);
    }

    public void setIgnoreMapModelValidation(boolean value) {
        this.getPreferences().setValue(PREF_IGNORE_MAPMODEL_VALIDATION, value);
    }

    public void setFigureTemplatesPath(URL path) {
        this.getPreferences().setValue(PREF_FIGURE_TEMPLATES, path == null ? "" : path.toString());
    }

    public void initializeDefaultPreferences() {
        DefaultScope scope = new DefaultScope();
        IEclipsePreferences node = scope.getNode(Plugin.getPluginID());
        node.putBoolean(PREF_GENERATE_RCP, false);
        node.putBoolean(PREF_USE_MAP_MODE, true);
        node.putBoolean(PREF_USE_RUNTIME_FIGURES, true);
        node.putBoolean(PREF_IGNORE_MAPMODEL_VALIDATION, false);
    }

    static boolean checkLiteOptionPresent() {
        return Platform.getBundle((String)"org.eclipse.gmf.codegen.lite") != null;
    }
}

