/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.bridge.ui.dashboard;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.ui.dashboard.Plugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class DashboardState {
    private static final String PREF_KEY = "gmf_dashboard";
    private static final String OPTION_PREFIX = "option_";
    private static final String DM_KEY = "domainModel";
    private static final String DGM_KEY = "domainGenerationModel";
    private static final String GDM_KEY = "graphicalDefinitionModel";
    private static final String TDM_KEY = "toolingDefinitionModel";
    private static final String MM_KEY = "mappingModel";
    private static final String GM_KEY = "generationModel";
    private URI dm;
    private URI dgm;
    private URI gdm;
    private URI tdm;
    private URI mm;
    private URI gm;
    private Set<String> enabledOptions = new HashSet<String>();
    private IProject project;

    public DashboardState() {
    }

    public DashboardState(IProject project) {
        this();
        this.project = project;
        Preferences prefs = this.getPreferences();
        if (prefs != null) {
            this.readOptions(prefs);
            this.dm = this.read(prefs, DM_KEY);
            this.dgm = this.read(prefs, DGM_KEY);
            this.gdm = this.read(prefs, GDM_KEY);
            this.tdm = this.read(prefs, TDM_KEY);
            this.mm = this.read(prefs, MM_KEY);
            this.gm = this.read(prefs, GM_KEY);
        }
    }

    public URI getDM() {
        return this.dm;
    }

    public URI getDGM() {
        return this.dgm;
    }

    public URI getGDM() {
        return this.gdm;
    }

    public URI getTDM() {
        return this.tdm;
    }

    public URI getMM() {
        return this.mm;
    }

    public URI getGM() {
        return this.gm;
    }

    public void setDM(URI uri) {
        this.dm = uri;
        this.write(DM_KEY, this.dm);
    }

    public void setDGM(URI uri) {
        this.dgm = uri;
        this.write(DGM_KEY, this.dgm);
    }

    public void setGDM(URI uri) {
        this.gdm = uri;
        this.write(GDM_KEY, this.gdm);
    }

    public void setTDM(URI uri) {
        this.tdm = uri;
        this.write(TDM_KEY, this.tdm);
    }

    public void setMM(URI uri) {
        this.mm = uri;
        this.write(MM_KEY, this.mm);
    }

    public void setGM(URI uri) {
        this.gm = uri;
        this.write(GM_KEY, this.gm);
    }

    public void setDM(IFile file) {
        this.dm = DashboardState.getURI(file);
        this.write(DM_KEY, this.dm);
    }

    public void setDGM(IFile file) {
        this.dgm = DashboardState.getURI(file);
        this.write(DGM_KEY, this.dgm);
    }

    public void setGDM(IFile file) {
        this.gdm = DashboardState.getURI(file);
        this.write(GDM_KEY, this.gdm);
    }

    public void setTDM(IFile file) {
        this.tdm = DashboardState.getURI(file);
        this.write(TDM_KEY, this.tdm);
    }

    public void setMM(IFile file) {
        this.mm = DashboardState.getURI(file);
        this.write(MM_KEY, this.mm);
    }

    public void setGM(IFile file) {
        this.gm = DashboardState.getURI(file);
        this.write(GM_KEY, this.gm);
    }

    private static URI getURI(IFile file) {
        if (file == null) {
            return null;
        }
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public int getModelsCount() {
        return 6;
    }

    public int getSpecifiedModelsCount() {
        int count = 0;
        if (this.dm != null) {
            ++count;
        }
        if (this.dgm != null) {
            ++count;
        }
        if (this.gdm != null) {
            ++count;
        }
        if (this.tdm != null) {
            ++count;
        }
        if (this.mm != null) {
            ++count;
        }
        if (this.gm != null) {
            ++count;
        }
        return count;
    }

    public boolean getOption(String name) {
        return this.enabledOptions.contains(name);
    }

    public void setOption(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value) {
            this.enabledOptions.add(name);
        } else {
            this.enabledOptions.remove(name);
        }
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            return;
        }
        String key = OPTION_PREFIX + name;
        if (value) {
            prefs.put(key, "*");
        } else {
            prefs.remove(key);
        }
        this.savePreferences(prefs);
    }

    private void readOptions(Preferences prefs) {
        try {
            String[] stringArray = prefs.keys();
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String key = stringArray[n];
                if (key.startsWith(OPTION_PREFIX)) {
                    this.enabledOptions.add(key.substring(OPTION_PREFIX.length()));
                }
                ++n;
            }
        }
        catch (BackingStoreException e) {
            IStatus status = Plugin.createError("Unable to read options", (Exception)((Object)e));
            Plugin.getDefault().getLog().log(status);
        }
    }

    private URI read(Preferences prefs, String key) {
        String s = prefs.get(key, null);
        if (s == null) {
            return null;
        }
        try {
            return URI.createURI((String)s);
        }
        catch (IllegalArgumentException e) {
            IStatus status = Plugin.createError("Invalid URI", e);
            Plugin.getDefault().getLog().log(status);
            return null;
        }
    }

    private void write(String key, URI uri) {
        if (this.project == null) {
            return;
        }
        String s = null;
        if (uri != null) {
            s = uri.toString();
        }
        Preferences prefs = this.getPreferences();
        prefs.put(key, s);
        this.savePreferences(prefs);
    }

    private void savePreferences(Preferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IStatus status = Plugin.createError("Unable to update state", (Exception)((Object)e));
            Plugin.getDefault().getLog().log(status);
        }
    }

    private Preferences getPreferences() {
        if (this.project == null) {
            return null;
        }
        Preferences node = this.getExistingPreferences();
        if (node != null) {
            return node;
        }
        return new ProjectScope(this.project).getNode(Plugin.getPluginID()).node(PREF_KEY);
    }

    private Preferences getExistingPreferences() {
        Preferences node;
        block8: {
            block7: {
                block6: {
                    if (this.project == null) {
                        return null;
                    }
                    node = Platform.getPreferencesService().getRootNode().node("project");
                    try {
                        if (node.nodeExists(this.project.getName())) break block6;
                        return null;
                    }
                    catch (BackingStoreException e) {
                        IStatus status = Plugin.createError("Unable to read state", (Exception)((Object)e));
                        Plugin.getDefault().getLog().log(status);
                        return null;
                    }
                }
                node = node.node(this.project.getName());
                if (node.nodeExists(Plugin.getPluginID())) break block7;
                return null;
            }
            node = node.node(Plugin.getPluginID());
            if (node.nodeExists(PREF_KEY)) break block8;
            return null;
        }
        return node.node(PREF_KEY);
    }
}

