/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.swt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.net4j.examples.mvc.IController;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractControlledDialog
extends Dialog
implements DisposeListener {
    private Map<String, IController> controllers = new HashMap<String, IController>();

    public AbstractControlledDialog(Shell parentShell) {
        super(parentShell);
    }

    public AbstractControlledDialog(IShellProvider parentShell) {
        super(parentShell);
    }

    public IController getFirstController() {
        return this.getControllers().next();
    }

    public IController getController(String name) {
        return this.controllers.get(name);
    }

    public void addController(IController controller) {
        this.controllers.put(controller.getName(), controller);
    }

    public Iterator<IController> getControllers() {
        return this.controllers.values().iterator();
    }

    public void create() {
        super.create();
        this.getContents().addDisposeListener((DisposeListener)this);
        this.initControllers();
        this.extractTargets(this.getContents());
        this.afterTargetsExtracted();
    }

    public boolean close() {
        if (this.getReturnCode() == 0) {
            Iterator<IController> it = this.getControllers();
            while (it.hasNext()) {
                if (it.next().mayClose()) continue;
                return false;
            }
        }
        return super.close();
    }

    public void widgetDisposed(DisposeEvent e) {
        Iterator<IController> it = this.getControllers();
        while (it.hasNext()) {
            it.next().dispose();
        }
    }

    protected void extractTargets(Control control) {
        Object targetData = control.getData("target");
        if (targetData instanceof String) {
            String targetName;
            String[] names = ((String)targetData).split("\\.");
            IController controller = names.length == 2 ? this.getController(names[0]) : null;
            String string = targetName = names.length == 2 ? names[1] : names[0];
            if (controller != null) {
                controller.putTarget(targetName, (Object)control);
            } else {
                Iterator<IController> it = this.getControllers();
                while (it.hasNext()) {
                    it.next().putTarget(targetName, (Object)control);
                }
            }
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            this.extractTargets(children);
        }
    }

    protected void extractTargets(Control[] controls) {
        int i = 0;
        while (i < controls.length) {
            this.extractTargets(controls[i]);
            ++i;
        }
    }

    protected void afterTargetsExtracted() {
        Iterator<IController> it = this.getControllers();
        while (it.hasNext()) {
            it.next().afterTargetsSet();
        }
    }

    protected abstract void initControllers();
}

