/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import org.eclipse.net4j.core.Acceptor;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.Executor;
import org.eclipse.net4j.core.Task;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public abstract class AbstractAcceptor
extends ServiceImpl
implements Acceptor {
    private Executor slaveStarter;

    public Executor getSlaveStarter() {
        return this.slaveStarter;
    }

    protected void deactivate() throws Exception {
        this.slaveStarter = null;
        super.deactivate();
    }

    public void setSlaveStarter(Executor slaveStarter) {
        this.doSet("slaveStarter", slaveStarter);
    }

    public void accept(Connector slave) {
        if (this.slaveStarter != null) {
            try {
                this.slaveStarter.execute(new StartSlaveTask(slave), null);
            }
            catch (Exception ex) {
                this.error("Error while starting slave " + slave, ex);
            }
        } else {
            this.startSlave(slave);
        }
    }

    protected void startSlave(Connector slave) {
        try {
            slave.start();
        }
        catch (Exception ex) {
            this.error("Error while starting slave " + slave, ex);
        }
    }

    private class StartSlaveTask
    implements Task {
        private Connector slave;

        public StartSlaveTask(Connector slave) {
            this.slave = slave;
        }

        public void execute() throws Exception {
            AbstractAcceptor.this.startSlave(this.slave);
        }
    }
}

