/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.results;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.results.AbstractModelResultEntryVisitor;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.results.IModelResultEntryVisitor;
import org.eclipse.emf.search.core.results.IModelSearchResult;
import org.eclipse.emf.search.core.results.ModelSearchResultEvent;
import org.eclipse.emf.search.l10n.Messages;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelSearchResult
extends AbstractTextSearchResult
implements IModelSearchResult,
IEditorMatchAdapter,
IFileMatchAdapter {
    private IModelSearchQuery searchQuery;
    private Map<Object, Collection<Object>> searchEntries;
    private Collection<ISearchResultListener> searchResultListeners;

    public ModelSearchResult(IModelSearchQuery query) {
        this.searchQuery = query;
        this.searchEntries = new HashMap<Object, Collection<Object>>();
        this.searchResultListeners = new ArrayList<ISearchResultListener>();
    }

    private void insert2(Collection<Object> currentEntrySubHierarchyCollection, IModelResultEntry entryToInsert, boolean notify) {
        boolean alreadyExist = false;
        for (Object currentEntrySubHierarchy : currentEntrySubHierarchyCollection) {
            alreadyExist = currentEntrySubHierarchy.equals(entryToInsert);
            if (!alreadyExist) continue;
            this.insert3(currentEntrySubHierarchy, entryToInsert.getResults(), notify);
            break;
        }
        if (!alreadyExist) {
            currentEntrySubHierarchyCollection.add(entryToInsert);
            if (notify) {
                this.fireItemAdded(entryToInsert);
            }
        }
    }

    private void insert3(Object currentEntrySubHierarchy, Collection<Object> entrySubtreeToInsertCollection, boolean notify) {
        for (Object e2i : entrySubtreeToInsertCollection) {
            if (!(e2i instanceof IModelResultEntry) || !(currentEntrySubHierarchy instanceof IModelResultEntry)) continue;
            this.insert2(((IModelResultEntry)currentEntrySubHierarchy).getResults(), (IModelResultEntry)e2i, notify);
        }
    }

    @Override
    public IModelResultEntry insert(Object file, IModelResultEntry entry, boolean notify) {
        if (this.searchEntries.get(file) == null) {
            this.searchEntries.put(file, new ArrayList());
        }
        this.insert2(this.searchEntries.get(file), entry, notify);
        return entry;
    }

    @Override
    public int getTotalMatches() {
        int result = 0;
        for (Object f : this.searchEntries.keySet()) {
            result += this.getMatchesNumberForFile(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMatches(Collection<Object> eCollection) {
        int result = 0;
        Collection<Object> collection = eCollection;
        synchronized (collection) {
            try {
                for (Object e : eCollection) {
                    if (!(e instanceof IModelResultEntry)) continue;
                    IModelResultEntry entry = (IModelResultEntry)e;
                    result += (entry.wasMatchedAtleastOnce() ? 1 : 0) + this.getMatches(entry.getResults());
                }
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @Override
    public int getMatchesNumberForFile(Object file) {
        return this.getMatches(this.searchEntries.get(file));
    }

    public Match[] getMatchesForFile(Object file) {
        if (this.searchEntries.get(file) != null && !this.searchEntries.get(file).isEmpty()) {
            return this.searchEntries.get(file).toArray(new Match[0]);
        }
        return new Match[0];
    }

    private IModelResultEntry fireItemAdded(IModelResultEntry item) {
        ModelSearchResultEvent searchResultEvent = new ModelSearchResultEvent(this);
        for (ISearchResultListener listener : this.searchResultListeners) {
            listener.searchResultChanged((SearchResultEvent)searchResultEvent);
        }
        return item;
    }

    @Override
    public Map<Object, Collection<Object>> getRootResultHierarchies() {
        return this.searchEntries;
    }

    private Collection<IModelResultEntry> accept(IModelResultEntryVisitor<IModelResultEntry> visitor) {
        for (Collection<Object> entries : this.searchEntries.values()) {
            for (Object entry : entries) {
                if (!(entry instanceof IModelResultEntry)) continue;
                this.accept2(visitor, (IModelResultEntry)entry);
            }
        }
        return visitor.getResults();
    }

    private void accept2(IModelResultEntryVisitor<IModelResultEntry> visitor, IModelResultEntry entry) {
        visitor.visit(entry);
        for (Object e : entry.getResults()) {
            if (!(e instanceof IModelResultEntry)) continue;
            this.accept2(visitor, (IModelResultEntry)e);
        }
    }

    @Override
    public Collection<IModelResultEntry> getResultsFlatenned() {
        return this.accept(new DefaultFlattenerModelResultEntryVisitor());
    }

    @Override
    public Collection<IModelResultEntry> getResultsFlatennedForFile(Object file) {
        return this.accept(new FileSpecifiedFlattenerModelResultEntryVisitor(file));
    }

    public void addListener(ISearchResultListener l) {
        if (!this.searchResultListeners.contains(l)) {
            this.searchResultListeners.add(l);
        }
    }

    public void removeListener(ISearchResultListener l) {
        this.searchResultListeners.remove(l);
    }

    @Override
    public void clean() {
        this.searchEntries = new HashMap<Object, Collection<Object>>();
    }

    public ImageDescriptor getImageDescriptor() {
        Bundle bundle = Platform.getBundle((String)this.searchQuery.getBundleSymbolicName());
        return ModelSearchImagesUtil.getImageDescriptor(bundle, this.searchQuery.getResultImagePath());
    }

    @Override
    public Image getImage() {
        Bundle bundle = Platform.getBundle((String)this.searchQuery.getBundleSymbolicName());
        return ModelSearchImagesUtil.getImage(bundle, this.searchQuery.getResultImagePath());
    }

    public ISearchQuery getQuery() {
        return this.searchQuery;
    }

    public String getLabel() {
        return this.getQuery().getLabel();
    }

    public String getTooltip() {
        return Messages.getString("ModelExtensibleSearchResult.queryResultMessage3");
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        Object adapted = editorInput.getAdapter(IFile.class);
        if (adapted instanceof IFile) {
            return this.computeContainedMatches(result, (IFile)adapted);
        }
        return new Match[0];
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        return false;
    }

    public Match[] getMatches(Object element) {
        if (element instanceof IModelResultEntry) {
            IModelResultEntry entry = (IModelResultEntry)element;
            Collection<Object> results = entry.getResults();
            if (results.isEmpty() && entry.getParent() != null && !entry.getParent().getResults().isEmpty()) {
                ArrayList<Object> siblingsWithoutItself = new ArrayList<Object>();
                siblingsWithoutItself.addAll(entry.getParent().getResults());
                siblingsWithoutItself.remove(entry);
                return siblingsWithoutItself.toArray(new Match[0]);
            }
            return results.toArray(new Match[0]);
        }
        return new Match[0];
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        if (result instanceof ModelSearchResult) {
            return ((ModelSearchResult)result).getMatchesForFile(file);
        }
        return new Match[0];
    }

    public IFile getFile(Object element) {
        if (element instanceof IModelResultEntry) {
            Object f = ((IModelResultEntry)element).getFile();
            return f instanceof IFile ? (IFile)f : null;
        }
        return null;
    }

    @Override
    public List<Object> getResultsObjectsAsList() {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (IModelResultEntry e : this.getResultsFlatenned()) {
            lst.add(e.getSource());
        }
        return lst;
    }

    @Override
    public List<Object> getResultsObjectsForFileAsList(Object file) {
        ArrayList<Object> lst = new ArrayList<Object>();
        for (IModelResultEntry e : this.getResultsFlatennedForFile(file)) {
            lst.add(e.getSource());
        }
        return lst;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultFlattenerModelResultEntryVisitor
    extends AbstractModelResultEntryVisitor<IModelResultEntry> {
        private DefaultFlattenerModelResultEntryVisitor() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileSpecifiedFlattenerModelResultEntryVisitor
    extends AbstractModelResultEntryVisitor<IModelResultEntry> {
        private Object target;

        public FileSpecifiedFlattenerModelResultEntryVisitor(Object file) {
            this.target = file;
        }

        @Override
        protected boolean isValid(IModelResultEntry entry) {
            return super.isValid(entry) && entry.getTarget().equals(this.target);
        }
    }
}

