/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.services.QueryTabDescriptor;

public final class ModelSearchQueryTabExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String EMF_UI_MODEL_SEARCH_QUERY_TABS_EXT_POINT_ID = String.valueOf(bundleId) + ".modelSearchQueryTab";
    private static ModelSearchQueryTabExtensionManager manager;
    private SortedSet<QueryTabDescriptor> queryContributions = new TreeSet<QueryTabDescriptor>(new Comparator<QueryTabDescriptor>(){

        @Override
        public int compare(QueryTabDescriptor o1, QueryTabDescriptor o2) {
            int c = o2.getIndex() - o1.getIndex();
            return c == 0 ? o2.getID().compareTo(o1.getID()) : c;
        }
    });

    protected ModelSearchQueryTabExtensionManager() {
        super(EMF_UI_MODEL_SEARCH_QUERY_TABS_EXT_POINT_ID);
        this.readRegistry();
    }

    public static ModelSearchQueryTabExtensionManager getInstance() {
        return manager == null ? (manager = new ModelSearchQueryTabExtensionManager()) : manager;
    }

    public QueryTabDescriptor find(String id) {
        for (QueryTabDescriptor desc : this.queryContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public QueryTabDescriptor[] getModelSearchQueryAreas() {
        return this.queryContributions.toArray(new QueryTabDescriptor[this.queryContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                this.queryContributions.add(new QueryTabDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelExtensibleSearchQueryTabExtensionManager.addExtensionErrorMessage"), (Throwable)ce));
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            String id = confElt.getAttribute("id");
            QueryTabDescriptor descriptor = this.find(id);
            this.queryContributions.remove(descriptor);
            ++n2;
        }
    }
}

