/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.scope;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.core.scope.ModelSearchScope;
import org.eclipse.emf.search.core.services.ModelExtensibleSearchEngineExtensionManager;
import org.eclipse.emf.search.core.services.ModelSearchEngineDescriptor;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelSearchWorkspaceScopeFactory {
    static ModelSearchWorkspaceScopeFactory instance;

    public static ModelSearchWorkspaceScopeFactory getInstance() {
        return instance == null ? (instance = new ModelSearchWorkspaceScopeFactory()) : instance;
    }

    private IModelSearchScope<Object, Resource> collectModelSearchScopeParticipants(IResource resource, ModelSearchScopeResourceVisitor visitor) {
        try {
            resource.accept((IResourceProxyVisitor)visitor, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ui", 0, Messages.getString("ModelSearchScopeFactory.ModelSearchScopeVisitorErrorMessage"), (Throwable)e));
        }
        return visitor.getModelSearchScope();
    }

    public IModelSearchScope<Object, Resource> createModelSearchWorkspaceScope(String engineID) {
        String workspaceScopeLabel = Messages.getString("AbstractModelSearchPage.workspaceScopeMessage");
        ModelSearchScope scope = new ModelSearchScope(workspaceScopeLabel);
        return this.collectModelSearchScopeParticipants((IResource)ResourcesPlugin.getWorkspace().getRoot(), new ModelSearchScopeResourceVisitor((IModelSearchScope<Object, Resource>)scope, engineID));
    }

    public IModelSearchScope<Object, Resource> createModelSearchScope(String engineID, Object selection) {
        String selectionScopeLabel = Messages.getString("AbstractModelSearchPage.selectionScopeMessage");
        IModelSearchScope<Object, Resource> scope = new IModelSearchScope<Object, Resource>(selectionScopeLabel);
        ModelSearchScopeResourceVisitor visitor = new ModelSearchScopeResourceVisitor(scope, engineID);
        if (selection instanceof IStructuredSelection) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                Object resource;
                if (!(o instanceof IAdaptable) || !((resource = ((IAdaptable)o).getAdapter(IResource.class)) instanceof IResource)) continue;
                scope = this.collectModelSearchScopeParticipants((IResource)resource, visitor);
            }
        }
        return scope;
    }

    public IModelSearchScope<Object, Resource> createModelProjectSearchScope(String engineID, String[] projectNames) {
        String projectsScopeLabel = Messages.getString("AbstractModelSearchPage.projectsScopeMessage");
        IModelSearchScope<Object, Resource> scope = new IModelSearchScope<Object, Resource>(projectsScopeLabel);
        ModelSearchScopeResourceVisitor visitor = new ModelSearchScopeResourceVisitor(scope, engineID);
        String[] stringArray = projectNames;
        int n = projectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null && project.isAccessible()) {
                scope = this.collectModelSearchScopeParticipants((IResource)project, visitor);
            }
            ++n2;
        }
        return scope;
    }

    public IModelSearchScope<Object, Resource> createModelSearchScope(String engineID, IWorkingSet[] workingSets) {
        String workingsetScopeLabel = Messages.getString("AbstractModelSearchPage.workingsetScopeMessage");
        IModelSearchScope<Object, Resource> scope = new IModelSearchScope<Object, Resource>(workingsetScopeLabel);
        ModelSearchScopeResourceVisitor visitor = new ModelSearchScopeResourceVisitor(scope, engineID);
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable adaptable = iAdaptableArray[n4];
                IProject project = (IProject)adaptable.getAdapter(IProject.class);
                if (project != null && project.isAccessible()) {
                    scope = this.collectModelSearchScopeParticipants((IResource)project, visitor);
                }
                ++n4;
            }
            ++n2;
        }
        return scope;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModelSearchScopeResourceVisitor
    implements IResourceProxyVisitor {
        IModelSearchScope<Object, Resource> modelSearchScope;
        String engineID;

        public ModelSearchScopeResourceVisitor(IModelSearchScope<Object, Resource> scope, String id) {
            this.modelSearchScope = scope;
            this.engineID = id;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            switch (proxy.getType()) {
                case 1: {
                    IResource resource = proxy.requestResource();
                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                    if (!this.isParticipantCurrentSearchEngineValid(uri)) break;
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                    Resource r = resourceSet.getResource(uri, true);
                    if (!(r instanceof Resource)) break;
                    this.modelSearchScope.addParticipant((Object)r);
                    break;
                }
            }
            return true;
        }

        public String getModelSearchEngineID() {
            return this.engineID;
        }

        public IModelSearchScope<Object, Resource> getModelSearchScope() {
            return this.modelSearchScope;
        }

        private boolean isParticipantCurrentSearchEngineValid(URI uri) {
            ModelSearchEngineDescriptor searchEngineDescriptor = ModelExtensibleSearchEngineExtensionManager.getInstance().find(this.engineID);
            return searchEngineDescriptor.getModelResourceValidator().check(uri);
        }
    }
}

