/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.providers;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.results.IModelSearchResult;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DecoratingModelSearchResultLabelProvider
extends AdapterFactoryLabelProvider
implements IColorProvider {
    private IModelSearchResult modelSearchResult;
    private static Color NORMAL_RESULT_COLOR = Display.getDefault().getSystemColor(2);
    private static Color UNMATCHED_RESULT_COLOR = Display.getDefault().getSystemColor(15);

    public DecoratingModelSearchResultLabelProvider(AdapterFactory adapterFactory, IModelSearchResult searchResult) {
        super(adapterFactory);
        this.modelSearchResult = searchResult;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IModelResultEntry && !((IModelResultEntry)element).wasMatchedAtleastOnce()) {
            return UNMATCHED_RESULT_COLOR;
        }
        return NORMAL_RESULT_COLOR;
    }

    public String getText(Object object) {
        if (object instanceof IModelResultEntry) {
            IModelResultEntry entry = (IModelResultEntry)object;
            int occurences = this.modelSearchResult.getMatches(entry.getResults());
            String occurenceMsg = String.valueOf(Messages.getString("ModelExtensibleSearchResultPage.Occurence1")) + (occurences > 1 ? Messages.getString("ModelExtensibleSearchResultPage.Occurence2") : "");
            return String.valueOf(super.getText((Object)((EObject)entry.getSource()))) + (entry.wasMatchedAtleastOnce() ? "" : " [" + occurences + " " + occurenceMsg + "]");
        }
        if (object instanceof Resource) {
            Resource file = (Resource)object;
            int nbMatches = this.modelSearchResult.getMatchesNumberForFile((Object)file);
            String messages = String.valueOf(Messages.getString("ModelExtensibleSearchResultPage.matchText1")) + nbMatches + Messages.getString("ModelExtensibleSearchResultPage.matchTex2") + (nbMatches > 1 ? Messages.getString("ModelExtensibleSearchResultPage.matchTex3") : Messages.getString("ModelExtensibleSearchResultPage.matchTex4")) + Messages.getString("ModelExtensibleSearchResultPage.matchTex5");
            if (file.getURI().isPlatformResource()) {
                return String.valueOf(file.getURI().toPlatformString(true)) + messages;
            }
            return String.valueOf(file.getURI().toFileString()) + messages;
        }
        return super.getText(object);
    }

    public Image getImage(Object object) {
        if (object instanceof IModelResultEntry) {
            return super.getImage(((IModelResultEntry)object).getSource());
        }
        if (object instanceof Resource) {
            return this.modelSearchResult.getImage();
        }
        return super.getImage(object);
    }

    public String getColumnText(Object object, int columnIndex) {
        if (object instanceof IModelResultEntry) {
            IModelResultEntry entry = (IModelResultEntry)object;
            int occurences = this.modelSearchResult.getMatches(entry.getResults());
            String occurenceMsg = String.valueOf(Messages.getString("ModelExtensibleSearchResultPage.Occurence1")) + (occurences > 1 ? Messages.getString("ModelExtensibleSearchResultPage.Occurence2") : "");
            return String.valueOf(super.getColumnText((Object)((EObject)entry.getSource()), columnIndex)) + (entry.wasMatchedAtleastOnce() ? "" : " [" + occurences + " " + occurenceMsg + "]");
        }
        if (object instanceof Resource) {
            Resource file = (Resource)object;
            int nbMatches = this.modelSearchResult.getMatchesNumberForFile((Object)file);
            String messages = String.valueOf(Messages.getString("ModelExtensibleSearchResultPage.matchText1")) + nbMatches + Messages.getString("ModelExtensibleSearchResultPage.matchTex2") + (nbMatches > 1 ? Messages.getString("ModelExtensibleSearchResultPage.matchTex3") : Messages.getString("ModelExtensibleSearchResultPage.matchTex4")) + Messages.getString("ModelExtensibleSearchResultPage.matchTex5");
            if (file.getURI().isPlatformResource()) {
                return String.valueOf(file.getURI().toPlatformString(true)) + messages;
            }
            return String.valueOf(file.getURI().toFileString()) + messages;
        }
        return super.getColumnText(object, columnIndex);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        if (object instanceof IModelResultEntry) {
            return super.getColumnImage(((IModelResultEntry)object).getSource(), columnIndex);
        }
        if (object instanceof Resource) {
            return this.modelSearchResult.getImage();
        }
        return super.getColumnImage(object, columnIndex);
    }

    public IModelSearchResult getModelSearchResult() {
        return this.modelSearchResult;
    }

    public void setModelSearchResult(IModelSearchResult modelSearchResult) {
        this.modelSearchResult = modelSearchResult;
    }
}

