/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.ui.areas;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.search.core.engine.TargetMetaElementSelectionEvent;
import org.eclipse.emf.search.core.engine.TargetSelectionEnum;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionMatchingHelper;
import org.eclipse.emf.search.ecore.ui.Activator;
import org.eclipse.emf.search.ecore.ui.l10n.Messages;
import org.eclipse.emf.search.ui.areas.AbstractModelSearchQueryArea;
import org.eclipse.emf.search.ui.pages.AbstractModelSearchPage;
import org.eclipse.emf.search.ui.services.QueryTabDescriptor;
import org.eclipse.emf.search.ui.utils.ModelSearchImages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EcoreTextualModelSearchQueryArea
extends AbstractModelSearchQueryArea
implements ISelectionProvider {
    private static final String EXPLANATORY_SEARCH_JOKERS_TEXT = Messages.getString("EcoreTextModelSearchQueryArea.searchExplanatoryMessage");
    private static final String REGEX_EXPRESSION_ERROR_MESSAGE = Messages.getString("EcoreTextModelSearchQueryArea.invaliRegExpErrorMessage");
    private static final String REGEX_EXPLANATION_LINK_MESSAGE = Messages.getString("EcoreTextModelSearchQueryArea.queryHelpHyperlinkMessage");
    private static final String ECORE_TEXT_MODEL_SEARCH_AREA_DIALOG_SECTION_ID = "EcoreTextModelSearchQueryArea";
    private static final String QUERY_LAST_SEARCHES_LIST_DIALOG_SETTINGS_ID = "queryLastSearchesList";
    private static final String REGEX_CHECKBOX_DIALOG_SETTINGS_ID = "regExCheckbox";
    private static final String CASE_SENSISTIVE_CHECKBOX_DIALOG_SETTINGS_ID = "caseSensitiveCheckbox";
    private static String SETTINGS_EXT = ".settings";
    private static int QUERY_LAST_SEARCHES_LIST_CAPACITY = 12;
    private AbstractModelSearchPage searchPage;
    private Group qGrp;
    private Combo searchQueryTextCombo;
    private Label searchQueryLabel;
    private Label searchQueryExplanatoryLabel;
    private Link javaRegexPatternUrlLink;
    private Button searchCaseSensitiveCheckBox;
    private Button searchRegularExpressionCheckBox;
    private List<String> lastQueriesList;
    private boolean hasAValidRegex = true;
    private Composite container;

    public EcoreTextualModelSearchQueryArea(Composite parent, AbstractModelSearchPage page, int style) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.container.setLayoutData((Object)new GridData(1808));
        this.searchPage = page;
        this.createControl(this.container);
        this.lastQueriesList = new ArrayList<String>(QUERY_LAST_SEARCHES_LIST_CAPACITY);
    }

    private boolean validateRegex() {
        if (this.searchRegularExpressionCheckBox.getSelection()) {
            try {
                ModelSearchQueryTextualExpressionMatchingHelper.createPattern((String)this.searchQueryTextCombo.getText(), (boolean)this.searchCaseSensitiveCheckBox.getSelection(), (boolean)true);
            }
            catch (Exception exception) {
                this.searchQueryExplanatoryLabel.setForeground(Display.getDefault().getSystemColor(3));
                this.searchQueryExplanatoryLabel.setText(REGEX_EXPRESSION_ERROR_MESSAGE);
                this.hasAValidRegex = false;
                this.validateStatus();
                return this.hasAValidRegex;
            }
            this.searchQueryExplanatoryLabel.setText("");
        } else {
            this.searchQueryExplanatoryLabel.setText(EXPLANATORY_SEARCH_JOKERS_TEXT);
        }
        this.searchQueryExplanatoryLabel.setForeground(this.getControl().getForeground());
        this.hasAValidRegex = true;
        return this.validateStatus();
    }

    private void createControl(Composite parent) {
        this.qGrp = new Group(parent, 0);
        this.qGrp.setLayout((Layout)new GridLayout(3, false));
        this.qGrp.setLayoutData((Object)new GridData(1808));
        this.qGrp.setText(Messages.getString("EcoreTextModelSearchQueryArea.textQueryGroupTitle"));
        this.searchQueryLabel = new Label((Composite)this.qGrp, 0);
        this.searchQueryLabel.setText(Messages.getString("EcoreTextModelSearchQueryArea.textQueryMessage"));
        this.searchQueryLabel.setLayoutData((Object)new GridData(1, 0, false, false, 3, 1));
        this.searchQueryTextCombo = new Combo((Composite)this.qGrp, 4);
        this.searchQueryTextCombo.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.searchQueryTextCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                EcoreTextualModelSearchQueryArea.this.validateRegex();
            }
        });
        this.searchCaseSensitiveCheckBox = new Button((Composite)this.qGrp, 32);
        this.searchCaseSensitiveCheckBox.setText(Messages.getString("EcoreTextModelSearchQueryArea.caseSensitiveMessage"));
        this.searchCaseSensitiveCheckBox.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.searchCaseSensitiveCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EcoreTextualModelSearchQueryArea.this.searchQueryTextCombo.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.searchQueryExplanatoryLabel = new Label((Composite)this.qGrp, 64);
        this.searchQueryExplanatoryLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.searchQueryExplanatoryLabel.setText(EXPLANATORY_SEARCH_JOKERS_TEXT);
        this.searchRegularExpressionCheckBox = new Button((Composite)this.qGrp, 32);
        this.searchRegularExpressionCheckBox.setText(Messages.getString("EcoreTextModelSearchQueryArea.regExpMessage"));
        this.searchRegularExpressionCheckBox.setLayoutData((Object)new GridData(16384, 0, false, false, 1, 1));
        this.searchRegularExpressionCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EcoreTextualModelSearchQueryArea.this.searchQueryExplanatoryLabel.setText(!EcoreTextualModelSearchQueryArea.this.searchRegularExpressionCheckBox.getSelection() ? EXPLANATORY_SEARCH_JOKERS_TEXT : "");
                EcoreTextualModelSearchQueryArea.this.searchCaseSensitiveCheckBox.setEnabled(!EcoreTextualModelSearchQueryArea.this.searchRegularExpressionCheckBox.getSelection());
                EcoreTextualModelSearchQueryArea.this.validateRegex();
                EcoreTextualModelSearchQueryArea.this.searchQueryTextCombo.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.javaRegexPatternUrlLink = new Link((Composite)this.qGrp, 0);
        this.javaRegexPatternUrlLink.setText(REGEX_EXPLANATION_LINK_MESSAGE);
        this.javaRegexPatternUrlLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ecore.ui", 0, Messages.getString("EcoreTextModelSearchQueryArea.webBrowserErrorMessage"), (Throwable)e));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.qGrp, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.searchQueryLabel, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.searchQueryTextCombo, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.searchCaseSensitiveCheckBox, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.searchQueryExplanatoryLabel, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.searchRegularExpressionCheckBox, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.javaRegexPatternUrlLink, "org.eclipse.emf.search.ecore.ui.EcoreTextModelSearchQueryArea");
        this.validateRegex();
    }

    public Control getControl() {
        return this.container;
    }

    public String getQueryExpression() {
        return this.searchQueryTextCombo.getText();
    }

    public void loadDialogSettings() {
        String[] lastQueries;
        IDialogSettings ecoreTextQuerySectionDialogSettings;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        String settingsPath = Activator.getDefault().getStateLocation().append(this.getDataMap().get("SETTINGS_PREFIX") + "_" + ((Object)((Object)this)).getClass().getSimpleName() + SETTINGS_EXT).toOSString();
        File settingsFile = new File(settingsPath);
        if (settingsFile.exists()) {
            try {
                settings.load(settingsPath);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.emf.search.ecore.ui", 0, Messages.getString("EcoreTextModelSearchQueryArea.dialogSettingsLoadErrorMessage"), (Throwable)e));
            }
        }
        if ((ecoreTextQuerySectionDialogSettings = settings.getSection(ECORE_TEXT_MODEL_SEARCH_AREA_DIALOG_SECTION_ID)) == null) {
            ecoreTextQuerySectionDialogSettings = settings.addNewSection(ECORE_TEXT_MODEL_SEARCH_AREA_DIALOG_SECTION_ID);
        }
        lastQueries = (lastQueries = ecoreTextQuerySectionDialogSettings.getArray(QUERY_LAST_SEARCHES_LIST_DIALOG_SETTINGS_ID)) == null ? new String[]{} : lastQueries;
        this.searchQueryTextCombo.setItems(lastQueries);
        this.lastQueriesList.addAll((Collection<String>)Arrays.asList(lastQueries));
        if (lastQueries != null && lastQueries.length > 0) {
            this.searchQueryTextCombo.select(0);
        } else {
            this.searchQueryTextCombo.setText("*");
        }
        this.searchQueryTextCombo.setFocus();
        boolean regexCheckboxSelection = ecoreTextQuerySectionDialogSettings.getBoolean(REGEX_CHECKBOX_DIALOG_SETTINGS_ID);
        this.searchRegularExpressionCheckBox.setSelection(regexCheckboxSelection);
        boolean caseSensitiveCheckboxSelection = ecoreTextQuerySectionDialogSettings.getBoolean(CASE_SENSISTIVE_CHECKBOX_DIALOG_SETTINGS_ID);
        this.searchCaseSensitiveCheckBox.setSelection(caseSensitiveCheckboxSelection);
        this.searchCaseSensitiveCheckBox.setEnabled(!regexCheckboxSelection);
        this.searchQueryExplanatoryLabel.setText(!regexCheckboxSelection ? EXPLANATORY_SEARCH_JOKERS_TEXT : "");
        this.searchQueryTextCombo.setFocus();
    }

    public void storeDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings ecoreTextQuerySectionDialogSettings = settings.getSection(ECORE_TEXT_MODEL_SEARCH_AREA_DIALOG_SECTION_ID);
        if (ecoreTextQuerySectionDialogSettings == null) {
            ecoreTextQuerySectionDialogSettings = settings.addNewSection(ECORE_TEXT_MODEL_SEARCH_AREA_DIALOG_SECTION_ID);
        }
        ecoreTextQuerySectionDialogSettings.put(QUERY_LAST_SEARCHES_LIST_DIALOG_SETTINGS_ID, this.lastQueriesList.toArray(new String[0]));
        ecoreTextQuerySectionDialogSettings.put(REGEX_CHECKBOX_DIALOG_SETTINGS_ID, this.searchRegularExpressionCheckBox.getSelection());
        ecoreTextQuerySectionDialogSettings.put(CASE_SENSISTIVE_CHECKBOX_DIALOG_SETTINGS_ID, this.searchCaseSensitiveCheckBox.getSelection());
        String settingsPath = Activator.getDefault().getStateLocation().append(this.getDataMap().get("SETTINGS_PREFIX") + "_" + ((Object)((Object)this)).getClass().getSimpleName() + SETTINGS_EXT).toOSString();
        File settingsFile = new File(settingsPath);
        if (!settingsFile.exists() || settingsFile.canWrite()) {
            try {
                settings.save(settingsPath);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ecore.ui", 0, Messages.getString("EcoreTextModelSearchQueryArea.dialogSettingsSaveErrorMessage"), (Throwable)e));
            }
        }
    }

    public void prepare() {
        String queryText = this.searchQueryTextCombo.getText();
        if (queryText != null && !queryText.equals("")) {
            if (this.lastQueriesList.size() >= QUERY_LAST_SEARCHES_LIST_CAPACITY) {
                this.lastQueriesList.remove(this.lastQueriesList.size() - 1);
            }
            this.lastQueriesList.add(0, queryText);
        }
        this.getDataMap().put("searchCaseSensitive", new Boolean(!this.searchCaseSensitiveCheckBox.isEnabled() ? false : this.searchCaseSensitiveCheckBox.getSelection()));
        this.getDataMap().put("searchRegularExpression", new Boolean(this.searchRegularExpressionCheckBox.getSelection()));
    }

    public boolean validateStatus() {
        boolean status = this.hasAValidRegex && !"".equals(this.getQueryExpression());
        this.searchPage.getContainer().setPerformActionEnabled(status);
        TabItem qTabItem = this.searchPage.getCurrentlySelectedQueryTabItem();
        if (qTabItem != null) {
            QueryTabDescriptor qTabDescriptor = this.searchPage.getCurrentlySelectedQueryDescriptor();
            qTabItem.setImage(!status ? ModelSearchImages.getErrorImage() : qTabDescriptor.getImage());
        }
        return this.hasAValidRegex;
    }

    public void handleTargetMetaModel(String targetMetaModelID) {
        this.notifyListeners(new TargetMetaElementSelectionEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(new Object[0]), targetMetaModelID, TargetSelectionEnum.NONE));
    }

    public EObject getTargetMetaElement() {
        return null;
    }

    public Collection<EObject> getTargetMetaElements() {
        return new ArrayList<EObject>();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

