/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.common.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.emf.search.core.parameters.IModelSearchQueryParameters;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.results.IModelSearchResult;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.core.services.ModelExtensibleSearchEngineExtensionManager;
import org.eclipse.emf.search.core.services.ModelSearchEngineDescriptor;
import org.eclipse.emf.search.ecore.common.ui.l10n.Messages;
import org.eclipse.emf.search.ecore.common.ui.utils.ModelSearchEditorUtils;
import org.eclipse.emf.search.ui.handlers.IModelElementEditorSelectionHandler;
import org.eclipse.emf.search.ui.pages.ModelEditorOpenEnum;
import org.eclipse.emf.search.ui.scope.ModelSearchWorkspaceScopeFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelSearchFilteredMetaElementsSelectionDialog
extends FilteredItemsSelectionDialog {
    private ModelExtensibleSearchEngineExtensionManager searchEngineExtensionManager = ModelExtensibleSearchEngineExtensionManager.getInstance();
    private IModelSearchResult result;
    protected ComposeableAdapterFactory listMetaElementParticipantAdapterFactory = new ComposedAdapterFactory(this.getMetaElementComposeableAdapterFactories());
    protected ILabelProvider listMetaElementParticipantLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.listMetaElementParticipantAdapterFactory){

        public String getText(Object object) {
            if (object instanceof IModelResultEntry) {
                IModelResultEntry modelResultEntry = (IModelResultEntry)object;
                return String.valueOf(AbstractModelSearchFilteredMetaElementsSelectionDialog.this.getElementName(object)) + (modelResultEntry.getParent() instanceof IModelResultEntry ? " - " + AbstractModelSearchFilteredMetaElementsSelectionDialog.this.getModelResultFullyQualifiedName(modelResultEntry.getParent()) : "");
            }
            return super.getText(object);
        }

        public Image getImage(Object object) {
            if (object instanceof IModelResultEntry) {
                return super.getImage(((IModelResultEntry)object).getSource());
            }
            return super.getImage(object);
        }
    };
    protected ComposeableAdapterFactory detailsMetaElementParticipantAdapterFactory;
    protected ILabelProvider detailsMetaElementParticipantLabelProvider;
    protected ModelEditorOpenEnum openEditorMode;
    private static final String META_ELEMENT_SELECTION_DIALOG_ID = "metaElementSelectionDialogID";
    private static final String OPEN_DIAGRAM_TOGGLE_SELECTION_ID = "openDiagramToggleSelectionID";

    protected abstract EClassifier getMetaElementParticipant();

    protected abstract boolean isAMetaElementToConsider(Object var1);

    public AbstractModelSearchFilteredMetaElementsSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
        this.setListLabelProvider(this.listMetaElementParticipantLabelProvider);
        this.detailsMetaElementParticipantAdapterFactory = new ComposedAdapterFactory(this.getMetaElementComposeableAdapterFactories());
        this.detailsMetaElementParticipantLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.listMetaElementParticipantAdapterFactory){

            public String getText(Object object) {
                if (object == null) {
                    return "";
                }
                if (object instanceof IModelResultEntry) {
                    String txt = AbstractModelSearchFilteredMetaElementsSelectionDialog.this.getModelResultFullyQualifiedName(((IModelResultEntry)object).getParent());
                    Object o = ((IModelResultEntry)object).getTarget();
                    return String.valueOf(txt) + " [" + ((Resource)o).getURI() + "]";
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (object instanceof IModelResultEntry && ((IModelResultEntry)object).getParent() != null) {
                    return super.getImage(((IModelResultEntry)object).getParent().getSource());
                }
                return super.getImage(object);
            }
        };
        this.setDetailsLabelProvider(this.detailsMetaElementParticipantLabelProvider);
        this.setTitle(Messages.getString("ModelSearchFilteredMetaElementsSelectionDialog.Title"));
        IModelSearchQuery query = this.newQuery(this.createFilter().getPattern());
        AbstractModelSearchFilteredMetaElementsSelectionDialog.setDefaultImage((Image)this.getModelSearchResultImage(query));
        query.run((IProgressMonitor)new NullProgressMonitor());
        this.result = query.getModelSearchResult();
    }

    public void create() {
        super.create();
        if (this.getPatternControl() instanceof Text) {
            ((Text)this.getPatternControl()).setText("?");
        }
    }

    private Image getModelSearchResultImage(IModelSearchQuery query) {
        Bundle bundle = Platform.getBundle((String)query.getBundleSymbolicName());
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(query.getResultImagePath()), null);
            return ImageDescriptor.createFromURL((URL)url).createImage();
        }
        return ImageDescriptor.getMissingImageDescriptor().createImage();
    }

    public abstract String getModelResultFullyQualifiedName(IModelResultEntry var1);

    protected abstract List<AdapterFactory> getMetaElementComposeableAdapterFactories();

    protected abstract IModelSearchQueryEvaluator<IModelSearchQuery, Resource> getModelQueryEvaluator();

    protected abstract String getModelSearchEngineID();

    protected abstract IModelElementEditorSelectionHandler getModelEditorSelectionHandler();

    private IModelSearchQuery newQuery(String filter) {
        ModelSearchEngineDescriptor searchEngine = this.searchEngineExtensionManager.find(this.getModelSearchEngineID());
        IModelSearchQueryParameters parameters = searchEngine.getModelSearchParametersFactory().createSearchQueryParameters();
        IModelSearchScope scope = ModelSearchWorkspaceScopeFactory.getInstance().createModelSearchWorkspaceScope(this.getModelSearchEngineID());
        parameters.setScope(scope);
        parameters.setEvaluator(this.getModelQueryEvaluator());
        parameters.setData("searchCaseSensitive", (Object)Boolean.FALSE);
        parameters.setData("searchRegularExpression", (Object)Boolean.FALSE);
        ArrayList<EClassifier> participantElements = new ArrayList<EClassifier>();
        participantElements.add(this.getMetaElementParticipant());
        parameters.setParticipantElements(participantElements);
        return searchEngine.getModelSearchQueryFactory().createModelSearchQuery(filter, parameters);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new MetaElementsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (IModelResultEntry e : this.result.getResultsFlatenned()) {
            if (!this.isAMetaElementToConsider(e)) continue;
            contentProvider.add((Object)e, itemsFilter);
        }
    }

    public abstract String getElementName(Object var1);

    protected Comparator<IModelResultEntry> getItemsComparator() {
        return new Comparator<IModelResultEntry>(){

            @Override
            public int compare(IModelResultEntry arg0, IModelResultEntry arg1) {
                String k1 = "";
                String k2 = "";
                if (arg0.getSource() instanceof EObject) {
                    k1 = ((EObject)arg0.getSource()).eClass().getInstanceClass().getCanonicalName();
                }
                if (arg1.getSource() instanceof EObject) {
                    k2 = ((EObject)arg1.getSource()).eClass().getInstanceClass().getCanonicalName();
                }
                return k1.compareTo(k2);
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return item instanceof IModelResultEntry ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    protected Control createExtendedContentArea(Composite parent) {
        ViewForm viewForm = new ViewForm(parent, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 50;
        viewForm.setLayoutData((Object)gd);
        final Button editorModeCheckBox = new Button((Composite)viewForm, 32);
        editorModeCheckBox.setLayoutData((Object)gd);
        editorModeCheckBox.setText(Messages.getString("AbstractModelSearchFilteredMetaElementsSelectionDialog.OpenEditorMode"));
        editorModeCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractModelSearchFilteredMetaElementsSelectionDialog.this.openEditorMode = editorModeCheckBox.getSelection() ? ModelEditorOpenEnum.DIAGRAM : ModelEditorOpenEnum.TREE;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        viewForm.setContent((Control)editorModeCheckBox);
        boolean openEditorButtonToggleMode = false;
        IDialogSettings openDiagramDialogSettings = this.getDialogSettings().getSection(META_ELEMENT_SELECTION_DIALOG_ID);
        if (openDiagramDialogSettings != null) {
            openEditorButtonToggleMode = openDiagramDialogSettings.getBoolean(OPEN_DIAGRAM_TOGGLE_SELECTION_ID);
        }
        this.openEditorMode = openEditorButtonToggleMode ? ModelEditorOpenEnum.DIAGRAM : ModelEditorOpenEnum.TREE;
        editorModeCheckBox.setSelection(ModelEditorOpenEnum.DIAGRAM.equals((Object)this.openEditorMode));
        return viewForm;
    }

    protected void storeDialog(IDialogSettings settings) {
        IDialogSettings openDiagramDialogSettings = settings.getSection(META_ELEMENT_SELECTION_DIALOG_ID);
        if (openDiagramDialogSettings == null) {
            openDiagramDialogSettings = settings.addNewSection(META_ELEMENT_SELECTION_DIALOG_ID);
        }
        boolean openEditorButtonToggleMode = ModelEditorOpenEnum.DIAGRAM.equals((Object)this.openEditorMode);
        openDiagramDialogSettings.put(OPEN_DIAGRAM_TOGGLE_SELECTION_ID, openEditorButtonToggleMode);
    }

    protected void okPressed() {
        super.okPressed();
        if (this.getResult() != null && this.getResult().length > 0 && this.getResult()[0] instanceof IModelResultEntry) {
            ModelSearchEditorUtils.openEditorWithSelection(this.getModelEditorSelectionHandler(), (EObject)((IModelResultEntry)this.getResult()[0]).getSource(), this.openEditorMode);
        }
    }

    private class MetaElementsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private MetaElementsFilter() {
            super((FilteredItemsSelectionDialog)AbstractModelSearchFilteredMetaElementsSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return AbstractModelSearchFilteredMetaElementsSelectionDialog.this.isAMetaElementToConsider(item);
        }

        public boolean matchItem(Object item) {
            if (this.isConsistentItem(item)) {
                return this.matches(AbstractModelSearchFilteredMetaElementsSelectionDialog.this.getElementName(item));
            }
            return false;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return false;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return false;
        }

        public int getMatchRule() {
            return 128;
        }
    }
}

