/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupAdapterImpl
extends AdapterImpl {
    protected NotifierEList targets;

    public void setTarget(Notifier target) {
        if (this.target != null) {
            if (this.targets == null) {
                this.targets = new NotifierEList();
            }
            this.targets.add(this.target);
        }
        super.setTarget(target);
        if (target instanceof EObject) {
            this.addGroupTargets(this.getGroupTargets((EObject)target));
        }
    }

    public void unsetTarget(Notifier target) {
        if (target instanceof EObject) {
            this.removeGroupTargets(this.getGroupTargets((EObject)target));
        }
        if (target == this.target) {
            if (this.targets == null) {
                super.setTarget(null);
            } else {
                super.setTarget((Notifier)this.targets.remove(this.targets.size() - 1));
                if (this.targets.isEmpty()) {
                    this.targets = null;
                }
            }
        } else if (this.targets != null && this.targets.remove(target) && this.targets.isEmpty()) {
            this.targets = null;
        }
    }

    public void dispose() {
        Notifier oldTarget = this.target;
        this.target = null;
        NotifierEList oldTargets = this.targets;
        this.targets = null;
        if (oldTarget != null) {
            oldTarget.eAdapters().remove((Object)this);
        }
        if (oldTargets != null) {
            Iterator iterator = oldTargets.iterator();
            while (iterator.hasNext()) {
                Notifier otherTarget = (Notifier)iterator.next();
                otherTarget.eAdapters().remove((Object)this);
            }
        }
    }

    public void notifyChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        Object feature = msg.getFeature();
        if (notifier instanceof EObject && feature instanceof EReference) {
            EObject object = (EObject)notifier;
            EReference ref = (EReference)feature;
            switch (msg.getEventType()) {
                case 3: {
                    if (!this.isGroupReference(object, ref)) break;
                    List<EObject> values = Collections.singletonList((EObject)msg.getNewValue());
                    this.addGroupTargets(values);
                    break;
                }
                case 5: {
                    if (!this.isGroupReference(object, ref)) break;
                    List values = (List)msg.getNewValue();
                    this.addGroupTargets(values);
                    break;
                }
                case 4: {
                    if (!this.isGroupReference(object, ref)) break;
                    List<EObject> values = Collections.singletonList((EObject)msg.getOldValue());
                    this.removeGroupTargets(values);
                    break;
                }
                case 6: {
                    if (!this.isGroupReference(object, ref)) break;
                    List values = (List)msg.getOldValue();
                    this.removeGroupTargets(values);
                    break;
                }
                case 1: {
                    List<EObject> values;
                    if (!this.isGroupReference(object, ref)) break;
                    if (msg.getOldValue() != null) {
                        values = Collections.singletonList((EObject)msg.getOldValue());
                        this.removeGroupTargets(values);
                    }
                    if (msg.getNewValue() == null) break;
                    values = Collections.singletonList((EObject)msg.getNewValue());
                    this.addGroupTargets(values);
                    break;
                }
                case 2: {
                    if (!this.isGroupReference(object, ref) || msg.getOldValue() == null) break;
                    List<EObject> values = Collections.singletonList((EObject)msg.getOldValue());
                    this.removeGroupTargets(values);
                }
            }
        }
    }

    protected void addGroupTargets(List<? extends Notifier> groupTargets) {
        for (Notifier notifier : groupTargets) {
            if (notifier.eAdapters().contains((Object)this)) continue;
            notifier.eAdapters().add((Object)this);
        }
    }

    protected void removeGroupTargets(List<? extends Notifier> groupTargets) {
        for (Notifier notifier : groupTargets) {
            notifier.eAdapters().remove((Object)this);
        }
    }

    protected List<EObject> getGroupTargets(EObject object) {
        BasicEList.FastCompare list = new BasicEList.FastCompare();
        List<EReference> refs = this.getGroupReferences(object);
        for (EReference ref : refs) {
            Object value = object.eGet((EStructuralFeature)ref);
            if (ref.isMany()) {
                EList values = (EList)value;
                list.addAll((Collection)values);
                continue;
            }
            if (value == null) continue;
            list.add((Object)((EObject)value));
        }
        return list;
    }

    protected boolean isGroupReference(EObject object, EReference ref) {
        List<EReference> list = this.getGroupReferences(object);
        if (list != null) {
            return list.contains(ref);
        }
        return false;
    }

    protected abstract List<EReference> getGroupReferences(EObject var1);

    protected Notifier getRootTarget() {
        return this.targets == null ? this.getTarget() : (Notifier)this.targets.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifierEList
    extends BasicEList.FastCompare<Notifier> {
        protected NotifierEList() {
        }

        protected boolean canContainNull() {
            return false;
        }
    }
}

