/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.core.protocol.AbstractCDOResProtocol;
import org.eclipse.emf.cdo.core.protocol.ResourceChangeInfo;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ServerCDOResProtocol;
import org.eclipse.emf.cdo.server.protocol.DeleteResourcesIndication;
import org.eclipse.emf.cdo.server.protocol.QueryAllResourcesIndication;
import org.eclipse.emf.cdo.server.protocol.ResourcesChangedRequest;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.ImplementationError;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCDOResProtocolImpl
extends AbstractCDOResProtocol
implements ServerCDOResProtocol {
    protected Mapper mapper;
    protected TransactionTemplate transactionTemplate;
    protected transient List<ServerCDOResProtocol.Listener> listeners = new ArrayList<ServerCDOResProtocol.Listener>();

    public int getType() {
        return 1;
    }

    public Indication createIndication(short signalId) {
        switch (signalId) {
            case 1: {
                return new QueryAllResourcesIndication();
            }
            case 4: {
                return new DeleteResourcesIndication();
            }
        }
        throw new ImplementationError("Invalid cdores signalId: " + signalId);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.doSet("mapper", mapper);
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.doSet("transactionTemplate", transactionTemplate);
    }

    @Override
    public void fireResourcesChangedNotification(List<ResourceChangeInfo> resourceChanges) {
        Channel[] channelArray = this.getChannels();
        int n = 0;
        int n2 = channelArray.length;
        while (n < n2) {
            Channel channel = channelArray[n];
            try {
                ResourcesChangedRequest signal = new ResourcesChangedRequest(resourceChanges);
                channel.transmit((Request)signal);
            }
            catch (Exception ex) {
                this.error("Error while notifying resource changes " + resourceChanges, ex);
            }
            ++n;
        }
    }

    @Override
    public void fireInvalidationNotification(Collection<Long> modifiedOIDs) {
        ServerCDOResProtocol.Listener[] array;
        ServerCDOResProtocol.Listener[] listenerArray = array = this.listeners.toArray(new ServerCDOResProtocol.Listener[this.listeners.size()]);
        int n = 0;
        int n2 = listenerArray.length;
        while (n < n2) {
            ServerCDOResProtocol.Listener listener = listenerArray[n];
            listener.notifyInvalidation(this, modifiedOIDs);
            ++n;
        }
    }

    @Override
    public void fireRemovalNotification(Collection<Integer> rids) {
        ServerCDOResProtocol.Listener[] array;
        ServerCDOResProtocol.Listener[] listenerArray = array = this.listeners.toArray(new ServerCDOResProtocol.Listener[this.listeners.size()]);
        int n = 0;
        int n2 = listenerArray.length;
        while (n < n2) {
            ServerCDOResProtocol.Listener listener = listenerArray[n];
            listener.notifyRemoval(this, rids);
            ++n;
        }
    }

    @Override
    public void addListener(ServerCDOResProtocol.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ServerCDOResProtocol.Listener listener) {
        this.listeners.remove(listener);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("mapper");
        this.assertNotNull("transactionTemplate");
    }

    protected void deactivate() throws Exception {
        this.listeners = null;
        this.mapper = null;
        this.transactionTemplate = null;
        super.deactivate();
    }
}

