/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.server.ClassInfo;
import org.eclipse.emf.cdo.server.PackageInfo;
import org.eclipse.emf.cdo.server.PackageListener;
import org.eclipse.emf.cdo.server.PackageManager;
import org.eclipse.emf.cdo.server.impl.PackageInfoImpl;
import org.eclipse.net4j.spring.impl.ServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManagerImpl
extends ServiceImpl
implements PackageManager {
    protected Map<Integer, ClassInfo> cidToClassInfoMap = new HashMap<Integer, ClassInfo>(2111);
    protected Map<String, ClassInfo> nameToClassInfoMap = new HashMap<String, ClassInfo>(2111);
    protected Map<ClassInfo, List<ClassInfo>> subClassInfoMap;
    protected Map<String, PackageInfo> packages = new HashMap<String, PackageInfo>();
    protected List<PackageListener> listeners = new ArrayList<PackageListener>();

    @Override
    public PackageInfo getPackageInfo(String name) {
        return this.packages.get(name);
    }

    @Override
    public PackageInfo addPackage(int pid, String name) {
        PackageInfoImpl packageInfo = new PackageInfoImpl(pid, name, this);
        this.packages.put(name, packageInfo);
        this.notifyPackageListeners();
        return packageInfo;
    }

    @Override
    public void addPackageListener(PackageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePackageListener(PackageListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void registerClassInfo(ClassInfo classInfo) {
        this.cidToClassInfoMap.put(new Integer(classInfo.getCID()), classInfo);
        this.nameToClassInfoMap.put(classInfo.getName(), classInfo);
        this.subClassInfoMap = null;
    }

    @Override
    public ClassInfo getClassInfo(int cid) {
        return this.cidToClassInfoMap.get(new Integer(cid));
    }

    @Override
    public ClassInfo getClassInfo(String name) {
        return this.nameToClassInfoMap.get(name);
    }

    @Override
    public List<ClassInfo> getSubClassInfos(ClassInfo base) {
        if (this.subClassInfoMap == null) {
            this.subClassInfoMap = new HashMap<ClassInfo, List<ClassInfo>>();
            Collection<ClassInfo> values = this.cidToClassInfoMap.values();
            ClassInfo[] array = values.toArray(new ClassInfo[values.size()]);
            int i = 0;
            while (i < array.length) {
                ClassInfo parent = array[i];
                ArrayList<ClassInfo> subClasses = new ArrayList<ClassInfo>();
                int j = 0;
                while (j < array.length) {
                    ClassInfo derived = array[j];
                    if (parent.isParentOf(derived)) {
                        subClasses.add(derived);
                    }
                    ++j;
                }
                this.subClassInfoMap.put(parent, subClasses);
                ++i;
            }
        }
        return this.subClassInfoMap.get(base);
    }

    protected void notifyPackageListeners() {
        for (PackageListener listener : this.listeners) {
            listener.notifyAddedPackage();
        }
    }

    protected void deactivate() throws Exception {
        this.cidToClassInfoMap = null;
        this.listeners = null;
        this.nameToClassInfoMap = null;
        this.packages = null;
        this.subClassInfoMap = null;
        super.deactivate();
    }
}

