/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dbgen.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.dbgen.SQLDialect;
import org.eclipse.emf.cdo.dbgen.impl.SQLDialectImpl;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.net4j.util.eclipse.Element;
import org.eclipse.net4j.util.eclipse.ExtensionParser;
import org.eclipse.net4j.util.eclipse.ListExtensionParser;
import org.osgi.framework.BundleContext;

public final class DBGenActivator
extends EMFPlugin {
    public static final DBGenActivator INSTANCE = new DBGenActivator();
    public static final String DIALECTS_EXT_POINT_ID = "dialects";
    public static final String PLUGIN_ID = "org.eclipse.emf.cdo.dbgen";
    private static Implementation plugin;
    private static List dialectElements;

    static {
        dialectElements = new ArrayList();
    }

    public DBGenActivator() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public SQLDialect createDialect(String dialectName) {
        DialectElement element = this.getDialectElement(dialectName);
        return new SQLDialectImpl(element);
    }

    public DialectElement getDialectElement(String dialectName) {
        for (DialectElement element : this.getDialectElements()) {
            if (!element.getName().equals(dialectName)) continue;
            return element;
        }
        return null;
    }

    public List getDialectElements() {
        return dialectElements;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    static /* synthetic */ List access$0() {
        return dialectElements;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private ExtensionParser dialectParser = new DialectParser(DBGenActivator.access$0());

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.emf.cdo.dbgen.dialects");
            this.dialectParser.parse(point);
        }

        public void stop(BundleContext context) throws Exception {
            this.dialectParser = null;
            dialectElements = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static class DialectElement
    extends Element {
        private String name;
        private String dropTableTemplate;
        private String createTableTemplate;
        private String createTablePrimaryTemplate;
        private String createIndexTemplate;
        private String createUniqueIndexTemplate;
        private String createPrimaryIndexTemplate;
        private List typeMappings = new ArrayList();

        public String toString() {
            return "Dialect(" + this.name + ")";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCreateIndexTemplate() {
            return this.createIndexTemplate;
        }

        public void setCreateIndexTemplate(String createIndexTemplate) {
            this.createIndexTemplate = createIndexTemplate;
        }

        public String getCreatePrimaryIndexTemplate() {
            return this.createPrimaryIndexTemplate;
        }

        public void setCreatePrimaryIndexTemplate(String createPrimaryIndexTemplate) {
            this.createPrimaryIndexTemplate = createPrimaryIndexTemplate;
        }

        public String getCreateTablePrimaryTemplate() {
            return this.createTablePrimaryTemplate;
        }

        public void setCreateTablePrimaryTemplate(String createTablePrimaryTemplate) {
            this.createTablePrimaryTemplate = createTablePrimaryTemplate;
        }

        public String getCreateTableTemplate() {
            return this.createTableTemplate;
        }

        public void setCreateTableTemplate(String createTableTemplate) {
            this.createTableTemplate = createTableTemplate;
        }

        public String getCreateUniqueIndexTemplate() {
            return this.createUniqueIndexTemplate;
        }

        public void setCreateUniqueIndexTemplate(String createUniqueIndexTemplate) {
            this.createUniqueIndexTemplate = createUniqueIndexTemplate;
        }

        public String getDropTableTemplate() {
            return this.dropTableTemplate;
        }

        public void setDropTableTemplate(String dropTableTemplate) {
            this.dropTableTemplate = dropTableTemplate;
        }

        public void addTypeMapping(TypeMappingElement dialect) {
            this.typeMappings.add(dialect);
        }

        public TypeMappingElement[] getTypeMappings() {
            return this.typeMappings.toArray(new TypeMappingElement[this.typeMappings.size()]);
        }
    }

    public static class DialectParser
    extends ListExtensionParser {
        public DialectParser(List list) {
            super(list);
            this.addFactory("dialect", new Element.Factory(){

                public Element createElementData() {
                    return new DialectElement();
                }
            });
            this.addFactory("dialect/typeMapping", new Element.Factory(){

                public Element createElementData() {
                    return new TypeMappingElement();
                }
            });
        }
    }

    public static class TypeMappingElement
    extends Element {
        private String sqlType;
        private String vendorString;

        public String toString() {
            return "TypeMapping(" + this.sqlType + ", " + this.vendorString + ")";
        }

        public String getSqlType() {
            return this.sqlType;
        }

        public void setSqlType(String sqlType) {
            this.sqlType = sqlType;
        }

        public String getVendorString() {
            return this.vendorString;
        }

        public void setVendorString(String vendorString) {
            this.vendorString = vendorString;
        }
    }
}

