/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.protocol;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.net4j.core.ITempManager;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;
import org.eclipse.net4j.examples.prov.Feature;
import org.eclipse.net4j.examples.prov.server.SiteManager;
import org.eclipse.net4j.examples.prov.server.protocol.ProvisioningServerProtocol;
import org.eclipse.net4j.util.IOHelper;

public class UploadArchiveIndication
extends AbstractIndicationWithResponse
implements Indication {
    private Feature[] features;
    private ITempManager tempManager;

    public UploadArchiveIndication(ITempManager tempManager) {
        this.tempManager = tempManager;
    }

    public short getSignalId() {
        return 4;
    }

    public void indicate() {
        String fileName = this.receiveString();
        long size = this.receiveLong();
        byte[] buffer = new byte[4096];
        int bufferSize = 0;
        File temp = null;
        File file = null;
        FileOutputStream os = null;
        try {
            try {
                temp = this.tempManager.createTempFolder("upload");
                file = new File(temp, fileName);
                os = new FileOutputStream(file);
                int i = 0;
                while ((long)i < size) {
                    buffer[bufferSize++] = this.receiveByte();
                    if (bufferSize == buffer.length) {
                        ((OutputStream)os).write(buffer);
                        bufferSize = 0;
                    }
                    ++i;
                }
                if (bufferSize > 0) {
                    ((OutputStream)os).write(buffer, 0, bufferSize);
                }
            }
            catch (IOException ex) {
                this.error("Error while receiving archive", ex);
            }
        }
        finally {
            IOHelper.close(os);
        }
        if (file != null) {
            this.features = this.getSiteManager().addResource(file, fileName);
        }
        this.tempManager.release(temp);
    }

    public void respond() {
        if (this.features == null) {
            this.transmitInt(-1);
        } else {
            this.transmitInt(this.features.length);
            int i = 0;
            while (i < this.features.length) {
                Feature feature = this.features[i];
                this.transmitString(feature.getId());
                this.transmitString(feature.getVersion());
                ++i;
            }
        }
    }

    private SiteManager getSiteManager() {
        return ((ProvisioningServerProtocol)this.getProtocol()).getSiteManager();
    }
}

