/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.eclipse.net4j.examples.prov.server.UrlCodec;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.ImplementationError;

public class UrlCodecImpl
extends ServiceImpl
implements UrlCodec {
    protected String charset;

    public String decode(String string) {
        try {
            return URLDecoder.decode(string, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ImplementationError("Charset " + this.charset + " has been tested before", (Throwable)ex);
        }
    }

    public String encode(String string) {
        try {
            return URLEncoder.encode(string, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ImplementationError("Charset " + this.charset + " has been tested before", (Throwable)ex);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.doSet("charset", charset);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("charset");
        try {
            String v1 = URLEncoder.encode("dummy", this.charset);
            String v2 = URLDecoder.decode(v1, this.charset);
            if (!"dummy".equals(v2)) {
                throw new ValidationException("Charset not bijective: " + this.charset);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new ValidationException("Unsupported Charset " + this.charset, (Throwable)ex);
        }
    }

    protected void deactivate() throws Exception {
        this.charset = null;
        super.deactivate();
    }
}

