/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.net4j.examples.prov.server.DateFormatter;
import org.eclipse.net4j.examples.prov.server.HttpdException;
import org.eclipse.net4j.examples.prov.server.ProvException;
import org.eclipse.net4j.examples.prov.server.SiteHttpd;
import org.eclipse.net4j.examples.prov.server.SiteManager;
import org.eclipse.net4j.examples.prov.server.UrlCodec;
import org.eclipse.net4j.examples.prov.server.protocol.ProvisioningServerProtocol;
import org.eclipse.net4j.examples.server.internal.ExampleServerPlugin;
import org.eclipse.net4j.spring.Container;
import org.eclipse.net4j.spring.ContainerCreationException;
import org.eclipse.net4j.spring.impl.ContainerImpl;
import org.eclipse.net4j.util.eclipse.AbstractPlugin;
import org.eclipse.net4j.util.eclipse.ResourcesHelper;
import org.osgi.framework.Bundle;

public class ProvServerPlugin
extends AbstractPlugin {
    public static final String PROJECT_NAME = "Provisioning";
    public static final String PLUGIN_RESOURCES_NAME = "resources";
    public static final String DOCUMENT_ROOT_NAME = "site";
    public static final String CONTEXT_PATH = "META-INF/";
    private static ProvServerPlugin plugin;
    private static Container container;
    private static IProject project;

    public ProvServerPlugin() {
        if (plugin == null) {
            plugin = this;
        }
    }

    public static ProvServerPlugin getDefault() {
        return plugin;
    }

    protected void doStart() throws Exception {
        try {
            ProvServerPlugin.copyPluginResource("favicon.ico");
            ProvServerPlugin.copyPluginResource("index.html");
            ProvServerPlugin.copyPluginResource("web/site.css");
            ProvServerPlugin.copyPluginResource("web/site.xsl");
        }
        catch (Exception ex) {
            throw new HttpdException("Error while initializing HTML pages", ex);
        }
    }

    protected void doStop() throws Exception {
        if (container != null) {
            container.close();
            container = null;
        }
        plugin = null;
    }

    public static Container getContainer() {
        if (container == null) {
            String baseResourcePath;
            try {
                baseResourcePath = ProvServerPlugin.getBundleLocation((Bundle)ProvServerPlugin.getDefault().getBundle());
            }
            catch (IOException ex) {
                throw new ContainerCreationException("Error while computing location of bundle " + ProvServerPlugin.getDefault().getBundle(), (Throwable)ex);
            }
            String location = "META-INF/density.server.provisioning.xml";
            String name = "provisioning";
            Container parent = ExampleServerPlugin.getNet4jContainer();
            ClassLoader classLoader = ProvServerPlugin.getDefault().getClassLoader();
            container = new ContainerImpl(baseResourcePath, location, name, parent, classLoader);
        }
        return container;
    }

    public static ProvisioningServerProtocol getProvisioningServerProtocol() {
        return (ProvisioningServerProtocol)((Object)ProvServerPlugin.getContainer().getBean("provisioningServerProtocol"));
    }

    public static SiteHttpd getHttpd() {
        return (SiteHttpd)ProvServerPlugin.getContainer().getBean("httpd");
    }

    public static DateFormatter getDateFormatter() {
        return (DateFormatter)ProvServerPlugin.getContainer().getBean("dateFormatter");
    }

    public static UrlCodec getUrlCodec() {
        return (UrlCodec)ProvServerPlugin.getContainer().getBean("urlCodec");
    }

    public static SiteManager getSiteManager() {
        return (SiteManager)ProvServerPlugin.getContainer().getBean("siteManager");
    }

    public static IProject getProject() {
        if (project == null) {
            try {
                project = ResourcesHelper.ensureProject((String)PROJECT_NAME);
            }
            catch (CoreException ex) {
                throw new ProvException("Error while creating project Provisioning", ex);
            }
        }
        return project;
    }

    public static void copyPluginResource(String path) throws IOException, CoreException {
        IFile file = ProvServerPlugin.getProject().getFile((IPath)new Path("site/" + path));
        ProvServerPlugin.copyPluginResource("resources/" + path, file);
    }

    public static void copyPluginResource(String fromPath, IFile toFile) throws IOException, CoreException {
        if (toFile.exists()) {
            return;
        }
        if (toFile.getParent() != null && toFile.getParent() instanceof IFolder) {
            ResourcesHelper.mkdirs((IFolder)((IFolder)toFile.getParent()), (IProgressMonitor)new NullProgressMonitor());
        }
        URL url = ProvServerPlugin.getDefault().getBundle().getEntry(fromPath);
        String[] content = ResourcesHelper.readFileIntoStringArray((InputStream)url.openStream());
        ResourcesHelper.writeFile((IFile)toFile, (String[])content, (IProgressMonitor)new NullProgressMonitor());
    }
}

