/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.actions.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenGeneratedAction
extends Action {
    protected final IItemJavaElementDescriptor descriptor;
    protected final Object target;

    public OpenGeneratedAction(IItemJavaElementDescriptor descriptor, Object target) {
        this.descriptor = descriptor;
        this.target = target;
        this.initialize();
    }

    protected void initialize() {
        this.setText(this.descriptor.getDisplayName(this.target));
        IJavaElement element = this.descriptor.getJavaElement(this.target);
        if (element != null && !element.exists()) {
            this.setEnabled(false);
        }
    }

    public void run() {
        IJavaElement element = this.descriptor.getJavaElement(this.target);
        try {
            if (element == null) {
                String typeName;
                IJavaTypeReference reference = this.descriptor.getJavaTypeReference(this.target);
                if (reference == null) {
                    return;
                }
                IJavaProject context = reference.getContext();
                element = context.findType(typeName = reference.getTypeName());
                if (element == null) {
                    String msg = NLS.bind((String)Messages.OpenGeneratedAction_LocateError, (Object)typeName, (Object)context.getProject().getName());
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.OpenGeneratedAction_ErrorFindType, (String)msg);
                    return;
                }
            }
            if (element instanceof ISourceReference) {
                JavaUI.openInEditor((IJavaElement)element);
            } else {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page != null) {
                    IPackagesViewPart view = (IPackagesViewPart)page.showView("org.eclipse.jdt.ui.PackageExplorer");
                    view.selectAndReveal((Object)element);
                }
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.OpenGeneratedAction_EditorError, (String)Messages.OpenGeneratedAction_ErrorOpenType, (IStatus)e.getStatus());
        }
    }
}

