/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public abstract class CommandAction implements IActionDelegate2, ICommandListener {

	protected final String commandId;
	
	protected IAction action;
	
	protected IServiceLocator locator;

	protected IShellProvider shellProvider;
	
	protected Command cmd;

	protected CommandAction(String commandId) {
		this.commandId = commandId;
	}
	
	protected void setAction(IAction action) {
		this.action = action;
	}
	
	protected void setPartSite(IWorkbenchPartSite site) {
		init(site, site);
	}
	
	protected void setWindow(IWorkbenchWindow window) {
		init(window, window);
	}

	public void init(IAction action) {
		setAction(action);
	}

	protected void init(IServiceLocator locator, IShellProvider shellProvider) {
		this.locator = locator;
		this.shellProvider = shellProvider;
		
		if (cmd != null) {
			cmd.removeCommandListener(this);
			cmd = null;
		}
		
		if (locator != null) {
			ICommandService svc = (ICommandService) locator.getService(ICommandService.class);
			cmd = svc.getCommand(commandId);
			cmd.addCommandListener(this);
			if (action != null)
				action.setEnabled(cmd.isEnabled());
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		// nothing to do
	}

	public void runWithEvent(IAction action, Event event) {
		if (cmd != null && cmd.isEnabled()) {
			IHandlerService svc = (IHandlerService) locator.getService(IHandlerService.class);
			try {
				cmd.executeWithChecks(svc.createExecutionEvent(cmd, event));
			} catch (ExecutionException e) {
				IStatus status = MintUI.getDefault().logError(getExecutionErrorMessage(e), e);
				ErrorDialog.openError(shellProvider.getShell(), null, null, status);
			} catch (NotDefinedException e) {
				MintUI.getDefault().logError(null, e);
			} catch (NotEnabledException e) {
				MintUI.getDefault().logError(null, e);
			} catch (NotHandledException e) {
				MintUI.getDefault().logError(null, e);
			}
		}
	}
	
	protected abstract String getExecutionErrorMessage(ExecutionException e);

	public final void run(IAction action) {
		throw new UnsupportedOperationException();
	}

	public void dispose() {
		if (cmd != null) {
			cmd.removeCommandListener(this);
			cmd = null;
		}
	}

	public void commandChanged(CommandEvent e) {
		if (e.isEnabledChanged() && action != null)
			action.setEnabled(e.getCommand().isEnabled());
	}
}