/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.core.impl;

import org.eclipse.emf.cdo.core.CDODataTypes;
import org.eclipse.emf.cdo.core.UnknownDataTypeException;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.spring.impl.ServiceImpl;

public abstract class AbstractConverter
extends ServiceImpl
implements CDODataTypes {
    protected Object dispatchFromChannel(Channel channel, int dataType) {
        switch (dataType) {
            case -1: {
                return this.fromChannelChar(channel);
            }
            case -2: {
                return this.fromChannelBoolean(channel);
            }
            case -3: {
                return this.fromChannelByte(channel);
            }
            case -4: {
                return this.fromChannelShort(channel);
            }
            case -5: {
                return this.fromChannelInteger(channel);
            }
            case -6: {
                return this.fromChannelLong(channel);
            }
            case -7: {
                return this.fromChannelFloat(channel);
            }
            case -8: {
                return this.fromChannelDouble(channel);
            }
            case 10: {
                return this.fromChannelString(channel);
            }
            case 11: {
                return this.fromChannelUserDefined(channel);
            }
        }
        throw new UnknownDataTypeException("Can't handle type " + dataType);
    }

    protected void dispatchToChannel(Channel channel, int dataType, Object value) {
        switch (dataType) {
            case -1: {
                this.toChannelChar(channel, value);
                break;
            }
            case -2: {
                this.toChannelBoolean(channel, value);
                break;
            }
            case -3: {
                this.toChannelByte(channel, value);
                break;
            }
            case -4: {
                this.toChannelShort(channel, value);
                break;
            }
            case -5: {
                this.toChannelInteger(channel, value);
                break;
            }
            case -6: {
                this.toChannelLong(channel, value);
                break;
            }
            case -7: {
                this.toChannelFloat(channel, value);
                break;
            }
            case -8: {
                this.toChannelDouble(channel, value);
                break;
            }
            case 10: {
                this.toChannelString(channel, value);
                break;
            }
            case 11: {
                this.toChannelUserDefined(channel, value);
                break;
            }
            default: {
                throw new UnknownDataTypeException("Can't handle type " + dataType);
            }
        }
    }

    protected Object fromChannelChar(Channel channel) {
        char value = channel.receiveChar();
        return new Character(value);
    }

    protected void toChannelChar(Channel channel, Object value) {
        char v = ((Character)value).charValue();
        channel.transmitChar(v);
    }

    protected Object fromChannelBoolean(Channel channel) {
        boolean value = channel.receiveBoolean();
        return new Boolean(value);
    }

    protected void toChannelBoolean(Channel channel, Object value) {
        boolean v = (Boolean)value;
        channel.transmitBoolean(v);
    }

    protected Object fromChannelByte(Channel channel) {
        byte value = channel.receiveByte();
        return new Byte(value);
    }

    protected void toChannelByte(Channel channel, Object value) {
        byte v = (Byte)value;
        channel.transmitByte(v);
    }

    protected Object fromChannelShort(Channel channel) {
        short value = channel.receiveShort();
        return new Short(value);
    }

    protected void toChannelShort(Channel channel, Object value) {
        short v = (Short)value;
        channel.transmitShort(v);
    }

    protected Object fromChannelInteger(Channel channel) {
        int value = channel.receiveInt();
        return new Integer(value);
    }

    protected void toChannelInteger(Channel channel, Object value) {
        int v = (Integer)value;
        channel.transmitInt(v);
    }

    protected Object fromChannelLong(Channel channel) {
        long value = channel.receiveLong();
        return new Long(value);
    }

    protected void toChannelLong(Channel channel, Object value) {
        long v = (Long)value;
        channel.transmitLong(v);
    }

    protected Object fromChannelFloat(Channel channel) {
        float value = channel.receiveFloat();
        return new Float(value);
    }

    protected void toChannelFloat(Channel channel, Object value) {
        float v = ((Float)value).floatValue();
        channel.transmitFloat(v);
    }

    protected Object fromChannelDouble(Channel channel) {
        double value = channel.receiveDouble();
        return new Double(value);
    }

    protected void toChannelDouble(Channel channel, Object value) {
        double v = (Double)value;
        channel.transmitDouble(v);
    }

    protected Object fromChannelString(Channel channel) {
        return channel.receiveString();
    }

    protected void toChannelString(Channel channel, Object value) {
        channel.transmitString((String)value);
    }

    protected Object fromChannelUserDefined(Channel channel) {
        return this.fromChannelString(channel);
    }

    protected void toChannelUserDefined(Channel channel, Object value) {
        this.toChannelString(channel, value);
    }
}

