/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.communication.packages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.EventPackage;

public class EventPackageWithFrames
extends EventPackage {
    public int cleanStackLevel;
    public List<SyntaxElement> frames = new ArrayList<SyntaxElement>();

    public EventPackageWithFrames(int event) {
        super(event);
    }

    @Override
    public void readContent(DataInputStream in) throws IOException {
        super.readContent(in);
        this.cleanStackLevel = in.readInt();
        int noOfFrames = in.readInt();
        int i = 0;
        while (i < noOfFrames) {
            SyntaxElement frame = new SyntaxElement();
            frame.readContent(in);
            this.frames.add(frame);
            ++i;
        }
    }

    @Override
    public void writeContent(DataOutputStream out) throws IOException {
        super.writeContent(out);
        out.writeInt(this.cleanStackLevel);
        out.writeInt(this.frames.size());
        for (SyntaxElement frame : this.frames) {
            frame.writeContent(out);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " ");
        sb.append(" clean=" + this.cleanStackLevel);
        sb.append(" " + this.frames.size() + " frames");
        return sb.toString();
    }
}

