/*******************************************************************************
 * Copyright (c) 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CleanGeneratedRefactoringDescriptor extends RefactoringDescriptor {
	
	public static final String ID = "org.eclipse.emf.mint.ui.CleanGenerated"; //$NON-NLS-1$
	
	private final Object[] elements;

	public CleanGeneratedRefactoringDescriptor(Object[] elements) {
		super(ID, null, "description", "comment", RefactoringDescriptor.STRUCTURAL_CHANGE | RefactoringDescriptor.MULTI_CHANGE); //$NON-NLS-1$ //$NON-NLS-2$
		this.elements = elements;
	}

	public Object[] getElements() {
		return elements;
	}

	@Override
	public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
		CleanGeneratedRefactoring refactoring = new CleanGeneratedRefactoring(elements);
		return refactoring;
	}
}