/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.views.ItemJavaElementDescriptor;
import org.eclipse.emf.mint.internal.ui.views.Messages;
import org.eclipse.emf.mint.internal.ui.views.UpdateViewerJob;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;

public class FindTypeJob
extends Job {
    private final ItemJavaElementDescriptor descriptor;
    private final IJavaTypeReference ref;
    private final UpdateViewerJob updateViewerJob;

    public FindTypeJob(ItemJavaElementDescriptor descriptor, IJavaTypeReference ref, UpdateViewerJob updateViewerJob) {
        super(NLS.bind((String)Messages.FindTypeJob_Name, (Object)ref.getTypeName()));
        this.descriptor = descriptor;
        this.ref = ref;
        this.updateViewerJob = updateViewerJob;
        this.setSystem(true);
    }

    public boolean belongsTo(Object family) {
        return family == this.updateViewerJob;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IType type = this.ref.getContext().findType(this.ref.getTypeName(), monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.updateViewerJob.addUpdate(this.descriptor, type);
        }
        catch (JavaModelException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

