package org.eclipse.emf.mint.internal.ui.views;

import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class JavaElementNavigator extends ViewPart implements ISelectionListener {

	private TableViewer viewer;

	private ComposedAdapterFactory adapterFactory;

	@Override
	public void createPartControl(Composite parent) {
		viewer = new TableViewer(parent, SWT.V_SCROLL | SWT.H_SCROLL | SWT.FULL_SELECTION);
		viewer.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
		viewer.setUseHashlookup(true);
		Table table = viewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		TableViewerColumn column = new TableViewerColumn(viewer, SWT.NONE);
		column.getColumn().setText("Element");

		TableViewerColumn column2 = new TableViewerColumn(viewer, SWT.NONE);
		column2.getColumn().setText("Display Name");

		TableViewerColumn column3 = new TableViewerColumn(viewer, SWT.NONE);
		column3.getColumn().setText("Category");

		TableColumnLayout layout = new TableColumnLayout();
		layout.setColumnData(column.getColumn(), new ColumnWeightData(1, true));
		layout.setColumnData(column2.getColumn(), new ColumnWeightData(1, true));
		layout.setColumnData(column3.getColumn(), new ColumnWeightData(1, true));
		parent.setLayout(layout);

		IWorkbenchSiteProgressService svc = (IWorkbenchSiteProgressService) getSite().getService(IWorkbenchSiteProgressService.class);
		UpdateViewerJob updateViewerJob = new UpdateViewerJob(viewer, svc);
		viewer.setLabelProvider(new ItemJavaElementLabelProvider(svc, updateViewerJob));
		viewer.setContentProvider(new ItemJavaElementContentProvider(adapterFactory, updateViewerJob));
		
		getViewSite().setSelectionProvider(viewer);
		selectionChanged(getSite().getPage().getActivePart(), getSite().getPage().getSelection());
		getSite().getPage().addPostSelectionListener(this);
	}

	@Override
	public void setFocus() {
		viewer.getControl().setFocus();
	}

	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		if (part == this)
			return;
		
		if (selection instanceof IStructuredSelection)
			viewer.setInput(((IStructuredSelection) selection).getFirstElement());
	}

	@Override
	public void dispose() {
		getSite().getPage().removePostSelectionListener(this);

		if (adapterFactory != null)
			adapterFactory.dispose();

		super.dispose();
	}
}
