/*******************************************************************************
 * Copyright (c) 2007, 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.search;

import java.util.ArrayList;
import java.util.Collections;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class GenModelMatchPresentation implements IMatchPresentation {

	public ILabelProvider createLabelProvider() {
		return new SearchResultLabelProvider();
	}

	public void showMatch(Match match, int currentOffset, int currentLength,
			boolean activate) throws PartInitException {
		IWorkbench wb = MintUI.getDefault().getWorkbench();
		if (wb == null)
			return;

		IWorkbenchWindow ww = wb.getActiveWorkbenchWindow();
		if (ww == null)
			return;

		IWorkbenchPage page = ww.getActivePage();
		if (page == null)
			return;

		GenModelMatch genModelMatch = (GenModelMatch) match;
		IFile file = genModelMatch.getFile();
		IEditorPart editor = IDE.openEditor(page, file, activate);
		if (editor instanceof GenModelEditor) {
			GenModelEditor genModelEditor = (GenModelEditor) editor;
			URI elementUri = EcoreUtil.getURI(genModelMatch.getEObject());
			EObject eObject = genModelEditor.getEditingDomain()
					.getResourceSet().getEObject(elementUri, true);
			if (eObject != null) {
				AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain) genModelEditor
						.getEditingDomain();
				genModelEditor.setSelectionToViewer(Collections
						.singleton(editingDomain.getWrapper(eObject)));
			}
		}
	}

	private static class SearchResultLabelProvider extends
			AdapterFactoryLabelProvider implements
			DelegatingStyledCellLabelProvider.IStyledLabelProvider {

		public SearchResultLabelProvider() {
			super(new ComposedAdapterFactory(
					ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
		}

		public StyledString getStyledText(Object object) {
			GenModelMatch.Element element = (GenModelMatch.Element) object;
			EObject eObject = element.getEObject();
			StyledString buf = new StyledString(super.getText(eObject));
			Object parent = eObject;
			while ((parent = getParent(parent)) != null) {
				String segment = null;
				Object unwrapped = AdapterFactoryEditingDomain.unwrap(parent);
				if (unwrapped instanceof EObject) {
					segment = super.getText(parent);
				} else {
					IFile file = element.getFile();
					StyledString.Styler styler = StyledString.QUALIFIER_STYLER;
					buf.append(" - ", styler); //$NON-NLS-1$
					IPath path = file.getFullPath().makeRelative();
					buf.append(path.toString(), styler);
					break;
				}

				if (segment != null)
					buf.append(" - ").append(segment); //$NON-NLS-1$
			}

			return buf;
		}

		public String getText(Object object) {
			return getStyledText(object).getString();
		}

		@Override
		public Image getImage(Object object) {
			EObject eObject = ((GenModelMatch.Element) object).getEObject();
			return super.getImage(eObject);
		}

		protected Image getImageFromObject(Object object) {
			ArrayList<Object> images = new ArrayList<Object>(2);
			images.add(object);
			images.add(MintUI.getDefault().getImageRegistry().get(
					MintUI.IMG_BLANK));
			return super.getImageFromObject(new ComposedImage(images));
		}

		private Object getParent(Object object) {
			ITreeItemContentProvider provider = (ITreeItemContentProvider) getAdapterFactory()
					.adapt(object, ITreeItemContentProvider.class);
			if (provider != null)
				return provider.getParent(object);

			return null;
		}

		@Override
		public void dispose() {
			((ComposedAdapterFactory) getAdapterFactory()).dispose();
			super.dispose();
		}
	}
}
