/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.emf.mint.internal.ui.search.GenModelMatch;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSearchMonitor
implements IQueryListener,
ISearchResultListener,
IResourceChangeListener {
    private static JavaSearchMonitor instance;
    private Map<ISearchResult, Collection<GenModelMatch>> results;
    private Map<IFile, Collection<GenModelMatch>> files;

    private JavaSearchMonitor() {
        NewSearchUI.addQueryListener((IQueryListener)this);
        ISearchQuery[] iSearchQueryArray = NewSearchUI.getQueries();
        int n = iSearchQueryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchQuery query = iSearchQueryArray[n2];
            this.queryAdded(query);
            ++n2;
        }
    }

    public void queryAdded(ISearchQuery query) {
        if (query.getSearchResult() instanceof AbstractTextSearchResult) {
            query.getSearchResult().addListener((ISearchResultListener)this);
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (query.getSearchResult() instanceof AbstractTextSearchResult) {
            query.getSearchResult().removeListener((ISearchResultListener)this);
            this.removeMatches(query.getSearchResult());
        }
    }

    public void searchResultChanged(SearchResultEvent event) {
        if (event instanceof RemoveAllEvent) {
            this.removeMatches(event.getSearchResult());
            return;
        }
        if (event instanceof MatchEvent) {
            ArrayList<GenModelMatch> matches = new ArrayList<GenModelMatch>();
            MatchEvent matchEvent = (MatchEvent)event;
            Match[] matchArray = matchEvent.getMatches();
            int n = matchArray.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof GenModelMatch) {
                    matches.add((GenModelMatch)match);
                }
                ++n2;
            }
            ISearchResult result = event.getSearchResult();
            if (matchEvent.getKind() == 1) {
                this.addMatches(result, matches);
            } else {
                this.removeMatches(result, matches);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        JavaSearchMonitor javaSearchMonitor = this;
        synchronized (javaSearchMonitor) {
            if (this.files == null) {
                return;
            }
        }
        final ArrayList<GenModelMatch> matches = new ArrayList<GenModelMatch>();
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean visit(IResourceDelta delta) throws CoreException {
                    JavaSearchMonitor javaSearchMonitor = JavaSearchMonitor.this;
                    synchronized (javaSearchMonitor) {
                        if (JavaSearchMonitor.this.files == null) {
                            return false;
                        }
                    }
                    IResource resource = delta.getResource();
                    int kind = delta.getKind();
                    if (resource.getType() == 1) {
                        if (kind == 2) {
                            JavaSearchMonitor.this.collectRemoved((IFile)resource, matches);
                        }
                        return false;
                    }
                    return kind != 1;
                }
            });
        }
        catch (CoreException e) {
            MintUI.getDefault().logError(null, e);
        }
        this.notifyRemoved(matches);
    }

    private synchronized void collectRemoved(IFile file, Collection<GenModelMatch> matches) {
        Collection<GenModelMatch> removed = this.files.remove(file);
        if (removed != null) {
            matches.addAll(removed);
            if (this.files.isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                this.files = null;
            }
        }
    }

    private void notifyRemoved(Collection<GenModelMatch> matches) {
        ISearchQuery[] queries;
        if (matches.isEmpty()) {
            return;
        }
        Match[] matchArray = matches.toArray(new Match[matches.size()]);
        ISearchQuery[] iSearchQueryArray = queries = NewSearchUI.getQueries();
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            ISearchQuery query = iSearchQueryArray[n2];
            if (query.getSearchResult() instanceof AbstractTextSearchResult) {
                ((AbstractTextSearchResult)query.getSearchResult()).removeMatches(matchArray);
            }
            ++n2;
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        for (GenModelMatch match : matches) {
            resources.add(match.getResource());
        }
        this.unload(resources);
    }

    private synchronized void addMatches(ISearchResult result, Collection<GenModelMatch> matches) {
        Collection<GenModelMatch> allMatches;
        if (this.results == null) {
            this.results = new HashMap<ISearchResult, Collection<GenModelMatch>>();
        }
        if ((allMatches = this.results.get(result)) == null) {
            allMatches = new HashSet<GenModelMatch>(2);
            this.results.put(result, allMatches);
        }
        allMatches.addAll(matches);
        if (this.files == null) {
            this.files = new HashMap<IFile, Collection<GenModelMatch>>();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        for (GenModelMatch match : matches) {
            allMatches = this.files.get(match.getFile());
            if (allMatches == null) {
                allMatches = new HashSet<GenModelMatch>(2);
                this.files.put(match.getFile(), allMatches);
            }
            allMatches.add(match);
        }
    }

    private synchronized void removeMatches(ISearchResult result, Collection<GenModelMatch> matches) {
        Collection<GenModelMatch> allMatches;
        if (this.results != null && (allMatches = this.results.get(result)) != null && allMatches.removeAll(matches) && allMatches.isEmpty()) {
            this.results.remove(result);
            if (this.results.isEmpty()) {
                this.results = null;
            }
        }
        this.removeMatchFiles(matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMatchFiles(Collection<GenModelMatch> matches) {
        HashSet<Resource> resources = new HashSet<Resource>();
        JavaSearchMonitor javaSearchMonitor = this;
        synchronized (javaSearchMonitor) {
            if (this.files != null) {
                for (GenModelMatch match : matches) {
                    IFile file = match.getFile();
                    Collection<GenModelMatch> allMatches = this.files.get(file);
                    if (allMatches == null || !allMatches.remove((Object)match) || !allMatches.isEmpty()) continue;
                    this.files.remove(file);
                    resources.add(match.getResource());
                    if (!this.files.isEmpty()) continue;
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                    this.files = null;
                    break;
                }
            }
        }
        if (!resources.isEmpty()) {
            this.unload(resources);
        }
    }

    private synchronized void removeMatches(ISearchResult result) {
        Collection<GenModelMatch> allMatches;
        if (this.results != null && (allMatches = this.results.remove(result)) != null) {
            this.removeMatchFiles(allMatches);
            if (this.results.isEmpty()) {
                this.results = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        NewSearchUI.removeQueryListener((IQueryListener)this);
        JavaSearchMonitor javaSearchMonitor = this;
        synchronized (javaSearchMonitor) {
            if (this.files != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                this.files = null;
            }
            if (this.results != null) {
                for (ISearchResult result : this.results.keySet()) {
                    result.removeListener((ISearchResultListener)this);
                }
                this.results = null;
            }
        }
    }

    private void unload(final Collection<Resource> resources) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    for (Resource resource : resources) {
                        resource.unload();
                    }
                }
            });
        }
    }

    public static synchronized void ensureStarted() {
        if (instance == null) {
            instance = new JavaSearchMonitor();
        }
    }

    public static synchronized void stop() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }
}

