/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.source;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationListener;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MemberAnnotationChangedEvent;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.emf.mint.internal.ui.source.Messages;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.themes.IThemeManager;

public class GeneratedElementDecorator
implements ILightweightLabelDecorator,
IMemberAnnotationListener,
IPropertyChangeListener {
    private final ListenerList listeners = new ListenerList();
    private IMemberAnnotationManager manager;
    private IThemeManager themeManager;
    private Color generatedColor;
    private Color generatedNotColor;
    private ColorJob colorJob;
    private final Object colorLock = new Object();

    public GeneratedElementDecorator() {
        this.manager = MintCore.getInstance().getMemberAnnotationManager();
        this.manager.addMemberAnnotationListener((IMemberAnnotationListener)this);
        this.themeManager = MintUI.getDefault().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] types = cu.getTypes();
                int i = 0;
                while (i < types.length) {
                    CodeGenStatus status = this.manager.getCodeGenStatus((IMember)types[i]);
                    if (status != CodeGenStatus.NONE) {
                        this.decorate(status, decoration);
                    }
                    ++i;
                }
                return;
            }
            if (!(element instanceof IMember)) {
                return;
            }
            CodeGenStatus status = this.manager.getCodeGenStatus((IMember)element);
            this.decorate(status, decoration);
        }
        catch (JavaModelException e) {
            MintCore.getInstance().logError(Messages.GeneratedElementDecorator_ErrorDecorate, (Throwable)e);
        }
    }

    private void decorate(CodeGenStatus status, IDecoration decoration) {
        Color color = null;
        switch (status) {
            case GENERATED: {
                color = this.getGeneratedColor();
                break;
            }
            case GENERATED_NOT: {
                color = this.getGeneratedNotColor();
            }
        }
        if (color != null) {
            decoration.setForegroundColor(color);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        this.themeManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.themeManager = null;
        this.manager.removeMemberAnnotationListener((IMemberAnnotationListener)this);
        this.manager = null;
        this.listeners.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireLabelProviderChangedEvent(final LabelProviderChangedEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final ILabelProviderListener listener = (ILabelProviderListener)l[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void memberAnnotationChanged(MemberAnnotationChangedEvent event) {
        this.fireLabelProviderChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getChanges().keySet().toArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent event) {
        boolean generatedColorChanged = "org.eclipse.emf.mint.ui.GENERATED_COLOR".equals(event.getProperty());
        boolean generatedNotColorChanged = "org.eclipse.emf.mint.ui.GENERATED_NOT_COLOR".equals(event.getProperty());
        if (generatedColorChanged || generatedNotColorChanged) {
            Object object = this.colorLock;
            synchronized (object) {
                if (this.colorJob == null) {
                    return;
                }
            }
            this.colorJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getGeneratedColor() {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.generatedColor == null && this.colorJob == null) {
                this.colorJob = new ColorJob();
            }
        }
        try {
            this.colorJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return this.generatedColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getGeneratedNotColor() {
        Object object = this.colorLock;
        synchronized (object) {
            if (this.generatedNotColor == null && this.colorJob == null) {
                this.colorJob = new ColorJob();
            }
        }
        try {
            this.colorJob.join();
        }
        catch (InterruptedException interruptedException) {}
        return this.generatedNotColor;
    }

    private class ColorJob
    extends WorkbenchJob {
        private boolean refresh;

        public ColorJob() {
            super(Messages.GeneratedElementDecorator_ThemeJob);
            this.setSystem(true);
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (GeneratedElementDecorator.this.themeManager == null) {
                return Status.CANCEL_STATUS;
            }
            ColorRegistry registry = GeneratedElementDecorator.this.themeManager.getCurrentTheme().getColorRegistry();
            Object object = GeneratedElementDecorator.this.colorLock;
            synchronized (object) {
                GeneratedElementDecorator.this.generatedColor = registry.get("org.eclipse.emf.mint.ui.GENERATED_COLOR");
                GeneratedElementDecorator.this.generatedNotColor = registry.get("org.eclipse.emf.mint.ui.GENERATED_NOT_COLOR");
            }
            if (this.refresh) {
                GeneratedElementDecorator.this.fireLabelProviderChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)GeneratedElementDecorator.this));
            }
            this.refresh = true;
            return Status.OK_STATUS;
        }
    }
}

