/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISources;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class OpenForeignModelsMenu extends CompoundContributionItem implements
		IWorkbenchContribution {

	private static final IContributionItem[] NO_ITEMS = {};

	private IServiceLocator serviceLocator;

	public void initialize(IServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	@Override
	protected IContributionItem[] getContributionItems() {
		IMenuService svc = (IMenuService) serviceLocator
				.getService(IMenuService.class);
		IWorkbenchWindow window = (IWorkbenchWindow) svc.getCurrentState()
				.getVariable(ISources.ACTIVE_WORKBENCH_WINDOW_NAME);
		if (window == null)
			return NO_ITEMS;

		IWorkbenchPage page = window.getActivePage();
		if (page == null)
			return NO_ITEMS;

		IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
		Object selection = svc.getCurrentState().getVariable(
				ISources.ACTIVE_MENU_SELECTION_NAME);
		if (selection instanceof IStructuredSelection) {
			ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
			boolean addSeparator = false;
			for (Iterator<?> i = ((IStructuredSelection) selection).iterator(); i
					.hasNext();) {
				GenModel genModel = (GenModel) i.next();
				EList<String> paths = genModel.getForeignModel();

				if (!items.isEmpty())
					addSeparator = true;

				for (String path : paths) {
					URI uri = URI.createURI(path).resolve(
							genModel.eResource().getURI());
					if (uri.isPlatformResource()) {
						if (addSeparator) {
							items.add(new Separator());
							addSeparator = false;
						}

						IFile file = root.getFile(new Path(uri
								.toPlatformString(true)));
						items.add(new ActionContributionItem(
								new OpenForeignModelAction(page, file)));
					}
				}
			}

			return items.toArray(new IContributionItem[items.size()]);
		}

		return NO_ITEMS;
	}
}
