/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;

/**
 * Adapter interface for producing a list of {@link IItemJavaElementDescriptor
 * Java element descriptors} given a model element.
 * 
 * <p>
 * Clients may implement this interface.
 * </p>
 * 
 * @see AdapterFactory
 */
public interface IItemJavaElementSource {

	/**
	 * Returns a list of Java element descriptors applicable to the given model
	 * element, or an empty list if none.
	 * 
	 * @param object
	 *            model element
	 * @return Java element descriptors
	 */
	List<IItemJavaElementDescriptor> getJavaElementDescriptors(Object object);
}
