/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;

public class CodeGenTag {

	private static final CodeGenTag GENERATED_TAG = new CodeGenTag(
			"@generated", Messages.CodeGenTag_desc_generated); //$NON-NLS-1$

	private static final CodeGenTag GENERATED_NOT_TAG = new CodeGenTag(
			"@generated NOT", //$NON-NLS-1$
			Messages.CodeGenTag_desc_generated_NOT);

	private static final CodeGenTag MODEL_TAG = new CodeGenTag("@model", //$NON-NLS-1$
			Messages.CodeGenTag_desc_model);

	private static final CodeGenTag EXTENDS_TAG = new CodeGenTag("@extends", //$NON-NLS-1$
			Messages.CodeGenTag_desc_extends);

	private static final CodeGenTag IMPLEMENTS_TAG = new CodeGenTag(
			"@implements", //$NON-NLS-1$
			Messages.CodeGenTag_desc_implements);

	private static final CodeGenTag ORDERED_TAG = new CodeGenTag("@ordered", //$NON-NLS-1$
			Messages.CodeGenTag_desc_ordered);

	private static final Map<Integer, List<CodeGenTag>> tags;

	static {
		HashMap<Integer, List<CodeGenTag>> map = new HashMap<Integer, List<CodeGenTag>>(
				3);
		map.put(IJavaElement.TYPE, Collections.unmodifiableList(Arrays.asList(
				GENERATED_TAG, GENERATED_NOT_TAG, MODEL_TAG, EXTENDS_TAG,
				IMPLEMENTS_TAG)));
		map.put(IJavaElement.METHOD, Collections.unmodifiableList(Arrays
				.asList(GENERATED_TAG, GENERATED_NOT_TAG, MODEL_TAG)));
		map.put(IJavaElement.FIELD, Collections.unmodifiableList(Arrays.asList(
				GENERATED_TAG, GENERATED_NOT_TAG, MODEL_TAG, ORDERED_TAG)));
		tags = map;
	}

	private final String tag;

	private final String description;

	private CodeGenTag(String tag, String description) {
		this.tag = tag;
		this.description = description;
	}

	public String getTag() {
		return tag;
	}

	public String getDescription() {
		return description;
	}

	public static List<CodeGenTag> getTags(IMember element) {
		return tags.get(element.getElementType());
	}
}
