/*******************************************************************************
 * Copyright (c) 2007, 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.filters;

import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;


public abstract class GeneratedElementFilter extends ViewerFilter {

	public final boolean select(Viewer viewer, Object parentElement,
			Object element) {
		if (viewer instanceof StructuredViewer)
			MintUI.getDefault().installFilterUpdater((StructuredViewer) viewer);

		if (element instanceof IMember && !(element instanceof IType)) {
			IMemberAnnotationManager mgr = MintCore.getInstance()
					.getMemberAnnotationManager();
			return mgr.getCodeGenStatus((IMember) element) != getAllowedStatus();
		}

		return true;
	}

	protected abstract CodeGenStatus getAllowedStatus();
}
