/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenGeneratedAction extends Action {

	protected final IItemJavaElementDescriptor descriptor;

	protected final Object target;

	public OpenGeneratedAction(IItemJavaElementDescriptor descriptor,
			Object target) {
		this.descriptor = descriptor;
		this.target = target;
		initialize();
	}

	protected void initialize() {
		setText(descriptor.getDisplayName(target));
		IJavaElement element = descriptor.getJavaElement(target);
		if (element != null && !element.exists())
			setEnabled(false);
	}

	@Override
	public void run() {
		IJavaElement element = descriptor.getJavaElement(target);
		try {
			if (element == null) {
				IJavaTypeReference reference = descriptor
						.getJavaTypeReference(target);
				if (reference == null)
					return;

				IJavaProject context = reference.getContext();
				String typeName = reference.getTypeName();
				element = context.findType(typeName);

				if (element == null) {
					String msg = NLS
							.bind(
									Messages.OpenGeneratedAction_LocateError,
									typeName, context.getProject().getName());
					MessageDialog.openError(PlatformUI.getWorkbench()
							.getActiveWorkbenchWindow().getShell(), Messages.OpenGeneratedAction_ErrorFindType,
							msg);
					return;
				}
			}

			if (element instanceof ISourceReference) {
				JavaUI.openInEditor(element);
			} else {
				IWorkbenchPage page = PlatformUI.getWorkbench()
						.getActiveWorkbenchWindow().getActivePage();
				if (page != null) {
					IPackagesViewPart view = (IPackagesViewPart) page
							.showView(JavaUI.ID_PACKAGES);
					view.selectAndReveal(element);
				}
			}
		} catch (CoreException e) {
			ErrorDialog.openError(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(),
					Messages.OpenGeneratedAction_EditorError,
					Messages.OpenGeneratedAction_ErrorOpenType, e
							.getStatus());
		}
	}
}