/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.emf.mint.internal.ui.search.GenModelMatch;
import org.eclipse.emf.mint.internal.ui.search.GenModelMatchPresentation;
import org.eclipse.emf.mint.internal.ui.search.JavaSearchMonitor;
import org.eclipse.emf.mint.internal.ui.search.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jdt.ui.search.IQueryParticipant;
import org.eclipse.jdt.ui.search.ISearchRequestor;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelQueryParticipant
implements IQueryParticipant {
    private static final String SEARCH_ACTIVITY_ID = "org.eclipse.emf.mint.ui.search";
    private static final String GENMODEL_EXT = "genmodel";
    private IMatchPresentation uiParticipant;
    private Boolean enabled;

    public int estimateTicks(QuerySpecification query) {
        if (!this.isEnabled(true)) {
            return 1;
        }
        if (query.getLimitTo() != 2 && query.getLimitTo() != 3) {
            return 1;
        }
        return 100;
    }

    public synchronized IMatchPresentation getUIParticipant() {
        if (this.uiParticipant == null) {
            this.uiParticipant = new GenModelMatchPresentation();
        }
        return this.uiParticipant;
    }

    public void search(ISearchRequestor requestor, QuerySpecification query, IProgressMonitor monitor) throws CoreException {
        if (!this.isEnabled(false)) {
            return;
        }
        if (query.getLimitTo() != 2 && query.getLimitTo() != 3) {
            return;
        }
        SearchHelper helper = null;
        monitor.beginTask(Messages.GenModelQueryParticipant_SearchTask, 2);
        try {
            SearchPattern pattern;
            String stringPattern;
            if (query instanceof ElementQuerySpecification) {
                IJavaElement element = ((ElementQuerySpecification)query).getElement();
                stringPattern = JavaElementLabels.getElementLabel((IJavaElement)element, (long)JavaElementLabels.ALL_DEFAULT);
                pattern = SearchPattern.createPattern((IJavaElement)element, (int)query.getLimitTo(), (int)24);
            } else {
                PatternQuerySpecification patternSpec = (PatternQuerySpecification)query;
                stringPattern = patternSpec.getPattern();
                int matchMode = this.getMatchMode(stringPattern) | 0x10;
                if (patternSpec.isCaseSensitive()) {
                    matchMode |= 8;
                }
                pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode);
            }
            IJavaSearchScope scope = query.getScope();
            IPath[] roots = scope.enclosingProjectsAndJars();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Collection<FileURI> fileURIs = this.findGenModels(roots, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (fileURIs.isEmpty()) {
                return;
            }
            helper = new SearchHelper(requestor, query, pattern, stringPattern.toCharArray());
            this.search((ResourceSet)resourceSet, fileURIs, helper, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
            monitor.done();
        }
    }

    private Collection<FileURI> findGenModels(IPath[] roots, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.GenModelQueryParticipant_CollectTask, roots.length);
        try {
            ArrayList<FileURI> result = new ArrayList<FileURI>();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < roots.length) {
                this.collectGenModels(workspaceRoot, roots[i], result);
                if (monitor.isCanceled()) {
                    Collection collection = Collections.emptySet();
                    return collection;
                }
                monitor.worked(1);
                ++i;
            }
            ArrayList<FileURI> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    private void collectGenModels(IWorkspaceRoot root, IPath path, final Collection<FileURI> collector) throws CoreException {
        IResource resource = root.findMember(path);
        if (resource != null) {
            switch (resource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    resource.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 1) {
                                GenModelQueryParticipant.this.visitFile((IFile)resource, collector);
                                return false;
                            }
                            return true;
                        }
                    });
                    break;
                }
                case 1: {
                    this.visitFile((IFile)resource, collector);
                }
            }
        }
    }

    private void visitFile(IFile file, Collection<FileURI> collector) {
        if (GENMODEL_EXT.equals(file.getFileExtension())) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
            collector.add(new FileURI(file, uri));
        }
    }

    private void search(ResourceSet resourceSet, Collection<FileURI> fileURIs, SearchHelper helper, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", fileURIs.size());
        try {
            for (FileURI fileURI : fileURIs) {
                IFile file = fileURI.getFile();
                monitor.subTask(file.getName());
                URI uri = fileURI.getURI();
                try {
                    Resource resource = resourceSet.getResource(uri, true);
                    TreeIterator i = resource.getAllContents();
                    while (i.hasNext()) {
                        this.search((EObject)i.next(), file, helper);
                    }
                }
                catch (RuntimeException e) {
                    String msg = NLS.bind((String)Messages.GenModelQueryParticipant_SearchError, (Object)uri);
                    MintUI.getDefault().logError(msg, e);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void search(EObject object, IFile file, SearchHelper helper) {
        AdapterFactory adapterFactory = helper.getAdapterFactory();
        Adapter adapter = adapterFactory.adapt((Notifier)object, IItemJavaElementSource.class);
        if (adapter instanceof IItemJavaElementSource) {
            IItemJavaElementSource provider = (IItemJavaElementSource)adapter;
            List descriptors = provider.getJavaElementDescriptors((Object)object);
            for (IItemJavaElementDescriptor descriptor : descriptors) {
                this.search(descriptor, object, file, helper);
            }
        }
    }

    private void search(IItemJavaElementDescriptor descriptor, EObject target, IFile file, SearchHelper helper) {
        QuerySpecification query = helper.getQuerySpecification();
        if (query instanceof ElementQuerySpecification) {
            IJavaElement queryElement = ((ElementQuerySpecification)query).getElement();
            IJavaElement element = descriptor.getJavaElement((Object)target);
            if (element == null) {
                IJavaTypeReference ref = descriptor.getJavaTypeReference((Object)target);
                String name = ref.getTypeName();
                if (helper.matches(name.toCharArray())) {
                    helper.reportMatch(target, file);
                }
            } else if (element.equals(queryElement)) {
                helper.reportMatch(target, file);
            }
        } else {
            IJavaElement element = descriptor.getJavaElement((Object)target);
            if (element == null) {
                IJavaTypeReference ref;
                String name;
                if (((PatternQuerySpecification)query).getSearchFor() == 7 && helper.matches((name = (ref = descriptor.getJavaTypeReference((Object)target)).getTypeName()).toCharArray())) {
                    helper.reportMatch(target, file);
                }
            } else {
                String name = element.getElementName();
                if (helper.matches(name.toCharArray())) {
                    helper.reportMatch(target, file);
                }
            }
        }
    }

    private int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (this.isCamelCasePattern(pattern)) {
            return 128;
        }
        return 0;
    }

    private boolean isCamelCasePattern(String pattern) {
        return SearchPattern.validateMatchRule((String)pattern, (int)128) == 128;
    }

    private synchronized boolean isEnabled(boolean update) {
        if (this.enabled != null && !update) {
            return this.enabled;
        }
        final IWorkbench wb = PlatformUI.getWorkbench();
        Display display = wb.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                IActivityManager mgr = wb.getActivitySupport().getActivityManager();
                GenModelQueryParticipant.this.enabled = mgr.getActivity(GenModelQueryParticipant.SEARCH_ACTIVITY_ID).isEnabled();
            }
        });
        return this.enabled;
    }

    private static class FileURI {
        private final IFile file;
        private final URI uri;

        public FileURI(IFile file, URI uri) {
            this.file = file;
            this.uri = uri;
        }

        public IFile getFile() {
            return this.file;
        }

        public URI getURI() {
            return this.uri;
        }
    }

    private static class SearchHelper {
        private final ISearchRequestor requestor;
        private final QuerySpecification querySpecification;
        private final SearchPattern searchPattern;
        private final char[] stringPatternChars;
        private ComposedAdapterFactory adapterFactory;

        public SearchHelper(ISearchRequestor requestor, QuerySpecification querySpecification, SearchPattern searchPattern, char[] stringPatternChars) {
            this.requestor = requestor;
            this.querySpecification = querySpecification;
            this.searchPattern = searchPattern;
            this.stringPatternChars = stringPatternChars;
        }

        public void reportMatch(EObject target, IFile file) {
            JavaSearchMonitor.ensureStarted();
            GenModelMatch match = new GenModelMatch(target, file);
            this.requestor.reportMatch((Match)match);
        }

        public boolean matches(char[] pattern) {
            return this.searchPattern.matchesName(this.stringPatternChars, pattern);
        }

        public QuerySpecification getQuerySpecification() {
            return this.querySpecification;
        }

        public AdapterFactory getAdapterFactory() {
            if (this.adapterFactory == null) {
                this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            }
            return this.adapterFactory;
        }

        public void dispose() {
            if (this.adapterFactory != null) {
                this.adapterFactory.dispose();
            }
        }
    }
}

