/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.mint.internal.ui.actions.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenForeignModelAction
implements IObjectActionDelegate {
    private static final String RESOURCE_URI_PREFIX = "platform:/resource/";
    private IWorkbenchPart targetPart;
    private IFile foreignModel;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        try {
            IDE.openEditor((IWorkbenchPage)this.targetPart.getSite().getPage(), (IFile)this.foreignModel);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.targetPart.getSite().getShell(), (String)Messages.OpenForeignModelAction_EditorError, (String)Messages.OpenForeignModelAction_ErrorOpenModel, (IStatus)e.getStatus());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        GenModel genModel = (GenModel)((IStructuredSelection)selection).getFirstElement();
        EList foreignModels = genModel.getForeignModel();
        if (foreignModels.isEmpty()) {
            action.setEnabled(false);
        } else {
            IResource foreignModelResource;
            URI foreignModelURI = URI.createURI((String)((String)foreignModels.get(0)));
            String foreignModelPath = foreignModelURI.resolve(genModel.eResource().getURI()).toString();
            if (foreignModelPath.startsWith(RESOURCE_URI_PREFIX)) {
                foreignModelPath = foreignModelPath.substring(RESOURCE_URI_PREFIX.length());
            }
            if ((foreignModelResource = ResourcesPlugin.getWorkspace().getRoot().findMember(foreignModelPath)) == null || foreignModelResource.getType() != 1) {
                action.setEnabled(false);
            } else {
                this.foreignModel = (IFile)foreignModelResource;
            }
        }
    }
}

