/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.jet.editor.dyncheck.JETAnnotationModel;
import org.eclipse.emf.codegen.jet.editor.scanners.JETTemplatePartitionScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

/**
 * @author jcheuoua
 * 
 * To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code
 * and Comments
 * @version $Revision: 1.2 $
 */
public class JETTemplateDocumentProvider extends FileDocumentProvider {

  private IPartitionTokenScanner scanner;

  /**
   * Method createDocument.
   * 
   * @param element
   *          Object
   * @return IDocument
   * @throws CoreException
   */
  public IDocument createDocument(Object element) throws CoreException {
    IDocument document = super.createDocument(element);
    if (document != null) {
      if (scanner == null)
        scanner = new JETTemplatePartitionScanner();
      IDocumentPartitioner partitioner = new FastPartitioner(scanner, JETTemplatePartitionScanner
          .getLegalContentTypes());
      if (partitioner != null) {
        partitioner.connect(document);
        document.setDocumentPartitioner(partitioner);
      }
    }
    return document;
  }

  /**
   * Gets or creates the partition scanner that will be attached to the documents created by this documentProvider.
   * 
   * @return IPartitionTokenScanner
   */
  public IPartitionTokenScanner getPartitionScanner() {
    if (scanner == null)
      scanner = new JETTemplatePartitionScanner();
    return scanner;
  }

  /**
   * Sets the partition scanner that will be attached to the documents created by this documentProvider.
   * 
   * @param scanner
   *          IPartitionTokenScanner
   */
  public void setPartitionScanner(IPartitionTokenScanner scanner) {
    this.scanner = scanner;
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.ui.texteditor.AbstractDocumentProvider#createAnnotationModel(java.lang.Object)
   */
  protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
    if (element instanceof IFileEditorInput) {
      IFileEditorInput input = (IFileEditorInput) element;
      return new JETAnnotationModel(input.getFile());
    }
    return super.createAnnotationModel(element);
  }
}
